import Vue from 'vue'
import Router from 'vue-router'
import home from '@/components/home'
import dataList from '@/components/dataList'
import finance from '@/components/finance'
import consume from '@/components/consume'
import surplus from '@/components/surplus'
import releaseInfo from '@/components/releaseInfo'
import info from '@/components/info'
import login from '@/components/login'
import checkCall from '@/components/checkCall'
import account from '@/components/account'
import slot from '@/components/slot'

Vue.use(Router)

export default new Router({
  routes: [
    {
      path: '/',
      name: 'home',
      component: home,
      meta: {requiresId: true},
      children: [
        {name: 'data', path: '', meta: {requiresId: false}, component: dataList},
        {name: 'dataList', path: '/dataList', meta: {requiresId: false}, component: dataList},
        {name: 'finance', path: '/finance', meta: {requiresId: false}, component: finance},
        {name: 'consume', path: '/consume', meta: {requiresId: false}, component: consume},
        {name: 'surplus', path: '/surplus', meta: {requiresId: false}, component: surplus},
        {name: 'releaseInfo', path: '/releaseInfo', meta: {requiresId: false}, component: releaseInfo},
        {name: 'info', path: '/info', meta: {requiresId: false}, component: info},
        {name: 'checkCall', path: '/checkCall', meta: {requiresId: false}, component: checkCall},
        {name: 'account', path: '/account', meta: {requiresId: false}, component: account},
        {name: 'slot', path: '/slot', meta: {requiresId: false}, component: slot}
      ]
    },
    {
      path: '/login',
      name: 'login',
      component: login,
      meta: {requiresId: false}
    }
  ]
})
