const mongodb = require('mongodb')
const mongoClient = mongodb.MongoClient
const app = require('express').Router()
const _ = require('lodash')
const moment = require('moment')
var db = {}
var reg = /@test.com$|@123.com$|@goyoo.com$|@xiaoyun.com$|^@|^test|@dis.com$|time-stone.cn$|^tangyong|^875652541|@1.com$|@xioayun.com$/i

const dbpath = process.env.MONGO || 'mongodb://10.11.3.123:1301/remarketing'
// const dbpath = 'mongodb://localhost:27017/remarketing'

mongoClient.connect(dbpath, function (err, res) {
  if (err) return console.log(err)
  db = res.db('remarketing')
  db.collection('msgTemps').find({}).toArray((err, r) => {
    console.log('数据库已经连接')
  })
})


// 登陆接口
app.post('/login', async function (req, res) {
  console.log('进入登陆')
  let body = req.body
  console.log(body)
  if (body.userName === 'admin') {
    if (body.password === 'goyooyunying') {
      res.send({status: 230, message: '登陆成功'})
    } else {
      res.send({ status: 200, message: '密码错误' })
    }
  } else {
    res.send({ status: 200, message: '账号错误' })
  }
})


// 获取首页数据
app.post('/dataList', async function (req, res) {
  console.log('进入了统计')
  let body = req.body
  let { startTime, endTime, total, pageSize, currentPage } = req.body
  console.log(body)
  console.log(startTime, endTime)

  let dateQs = getTimeRange({start: startTime, end: endTime, key: 'date'})
  // console.log(dateQs)

  let results = await db.collection('dailyStats').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        pv: {$sum: '$pv'},
        uid: {$sum: '$uid'}
      }
    }
    ]).sort({'date': -1}).toArray()
  // console.log(results)

  let touchCount = await db.collection('recognition').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        touchCount: {$sum: 1}
      }
    }
  ]).sort({'date': -1}).toArray()
  // console.log(touchCount)

  let creatQs = getTimeRange({start: startTime, end: endTime, key: 'createdAt'})
  console.log(creatQs)

  let msgTask = await db.collection('task').aggregate([
    {
      $match: creatQs
    },
    {
      $group: {
        _id: '$accountID',
        msgCount: {$sum: 1}
      }
    }]).sort({'date': -1}).toArray()
  // console.log(msgTask)

  let callTask = await db.collection('callTask').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        callCount: {$sum: 1}
      }
    }]).sort({'date': -1}).toArray()
  // console.log(callTask)

  let companyName = await db.collection('account').aggregate([
    {
      $project: {
        _id: '$_id',
        company: '$company',
        email: '$email'
      }
    }]).sort({'date': -1}).toArray()
  // console.log(companyName)

  let auditDate = getTimeRange({start: startTime, end: endTime, key: 'auditAt'})
  console.log(auditDate)
  let getCount = await db.collection('recognition').aggregate([
    {
      $match: auditDate
    },
    {
      $group: {
        _id: '$pubID',
        getCount: {$sum: 1}
      }
    }]).sort({'date': -1}).toArray()

  let dataArr = []
  let item = {}

  companyName.forEach(x => {
    item.time = startTime + ' 至 ' + endTime
    item.company = x.company
    item.email = x.email
    results.forEach(y => {
      if (y._id + '' === x._id + '') {
        item.pv = y.pv
        item.uid = y.uid
      }
    })
    touchCount.forEach(z => {
      if (z._id + '' === x._id + '') {
        item.touchCount = z.touchCount
      }
    })
    getCount.forEach(m => {
      if (m._id + '' === x._id + '') {
        item.getCount = m.getCount
      }
    })
    msgTask.forEach(n => {
      if (n._id + '' === x._id + '') {
        item.msgCount = n.msgCount
      }
    })
    callTask.forEach(o => {
      if (o._id + '' === x._id + '') {
        item.callCount = o.callCount
      }
    })
    // if (item.pv || item.touchCount || item.getCount || item.msgCount || item.callCount) {
    //   dataArr.push(item)
    // }
    if (!reg.test(item.email)) {
      dataArr.push(item)
    }
    item = {}
  })
  let arrTotal = dataArr.length

  // dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  // console.log(dataArr)
  res.send({status: 200, total: arrTotal, data: dataArr})
})


// 消费数据
app.post('/consume', async function (req, res) {
  console.log('进入了消费')

  let { startTime, endTime, total, pageSize, currentPage } = req.body

  startTime = moment(startTime).startOf('day').toDate()
  endTime = moment(endTime).endOf('day').toDate()

  console.log(startTime)
  console.log(endTime)

  let counsume = await db.collection('bills').aggregate([
    {
      $match: {createdAt: {$gt: startTime, $lte: endTime}}
    },
    {
      $group: {
        _id: {accountID: '$accountID', pre: '$pre'},
        number: {$sum: '$number'}
      }
    }]).toArray()

  console.log(counsume)

  let companyName = await db.collection('account').find({}).sort({'date': -1}).toArray()

  let data = []
  let preData = []
  for (let i = 0; i < counsume.length; i++) {
    if (counsume[i]._id.pre === true) {
      preData.push({_id: counsume[i]._id.accountID, preNumber: counsume[i].number})
    } else {
      data.push({_id: counsume[i]._id.accountID, number: counsume[i].number})
    }
  }
  // console.log(data)
  // console.log(preData)



  startTime = moment(startTime).startOf('day').format('YYYY-MM-DD')
  endTime = moment(endTime).endOf('day').format('YYYY-MM-DD')

  let dataArr = []
  let item = {}
  companyName.forEach(x => {
    item.time = startTime + ' 至 ' + endTime
    item.company = x.company
    item.email = x.email
    data.forEach(y => {
      if (x._id + '' === y._id + '' || x._id === y._id) {
        item.number = y.number
      }
    })
    preData.forEach(z => {
      if (z._id + '' === x._id + '' || z._id === x._id) {
        item.preNumber = z.preNumber
      }
    })
    // if (item.number || item.preNumber) {
    //   dataArr.push(item)
    // }
    if (!reg.test(item.email)) {
      dataArr.push(item)
    }
    item = {}
  })
  let dataTotal = dataArr.length
  console.log(dataArr)

  let preTotalNumber = 0
  let consumeTotalNumber = 0
  dataArr.forEach(x => {
    if (typeof (x.number) === 'number') {
      consumeTotalNumber += x.number
    }
    if (typeof (x.preNumber) === 'number') {
      preTotalNumber += x.preNumber
    }
  })
  console.log(consumeTotalNumber)
  console.log(preTotalNumber)
  // dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  res.send({status: 200, consumeTotalNumber: consumeTotalNumber, preTotalNumber: preTotalNumber, total: dataTotal, data: dataArr})
})

// 充值数据
app.post('/finance', async function (req, res) {
  console.log('进入充值')

  console.log(req.body)

  let { startTime, endTime, total, pageSize, currentPage } = req.body

  startTime = moment('2018-01-01').startOf('day').toDate()
  endTime = moment(endTime).endOf('day').toDate()
  console.log(startTime)
  console.log(endTime)

  let finance = await db.collection('recharge').aggregate([
    {
      $match: {createdAt: {$gt: startTime, $lte: endTime}}
    },
    {
      $group: {
        _id: '$accountID',
        number: {$sum: '$number'}
      }
    }]).toArray()

  let companyName = await db.collection('account').aggregate([
    {
      $project: {
        _id: '$_id',
        company: '$company',
        email: '$email'
      }
    }]).sort({'date': -1}).toArray()

  startTime = moment(startTime).startOf('day').format('YYYY-MM-DD')
  endTime = moment(endTime).startOf('day').format('YYYY-MM-DD')

  let dataArr = []
  let item = {}
  companyName.forEach(x => {
    item.time = startTime + ' 至 ' + endTime
    item.company = x.company
    item.email = x.email
    finance.forEach(y => {
      if (x._id + '' === y._id + '') {
        item.number = y.number
      }
    })
    // if (item.number) {
    //   dataArr.push(item)
    // }

    if (!reg.test(item.email)) {
      dataArr.push(item)
    }
    item = {}
  })
  let dataTolal = dataArr.length

  let financeNumber = 0
  console.log(financeNumber)
  for (let i = 0; i < dataArr.length; i++) {
    if (dataArr[i].number) {
      financeNumber += dataArr[i].number
    }
  }
  financeNumber = financeNumber.toFixed(2)
  // dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)

  res.send({status: 200, financeNumber: financeNumber, total: dataTolal, data: dataArr})
})


// 余额数据
app.post('/surplus', async function (req, res) {
  console.log('进入了余额')

  let { startTime, endTime, total, pageSize, currentPage } = req.body

  startTime = moment('2018-01-01').startOf('day').toDate()
  endTime = moment(endTime).endOf('day').toDate()
  console.log(startTime)
  console.log(endTime)

  let consume = await db.collection('bills').aggregate([
    {
      $match: {createdAt: {$gt: startTime, $lte: endTime}}
    },
    {
      $group: {
        _id: '$accountID',
        number: {$sum: '$number'}
      }
    }]).toArray()

  let add = await db.collection('recharge').aggregate([
    {
      $group: {
        _id: '$accountID',
        number: {$sum: '$number'}
      }
    }]).toArray()


  let companyName = await db.collection('account').find({}).sort({'date': -1}).toArray()


  let dataArr = []
  startTime = moment(startTime).startOf('day').format('YYYY-MM-DD')
  endTime = moment(endTime).startOf('day').format('YYYY-MM-DD')
  companyName.forEach(x => {
    let item = {}
    item.time = '截至' + endTime
    item.createdAt = moment(x.createdAt).format('YYYY-MM-DD')
    item.company = x.company
    item.email = x.email
    item.consumeNum = 0
    item.addNum = 0
    consume.forEach(y => {
      if (x._id + '' === y._id + '' || x._id === y._id) {
        if (typeof (y.number) === 'number') {
          item.consumeNum = y.number
        } else {
          item.consumeNum = 0
        }
      }
    })
    add.forEach(z => {
      if (x._id + '' === z._id + '' || x._id === z._id) {
        if (typeof (z.number) === 'number') {
          item.addNum = z.number
        } else {
          item.consumeNum = 0
        }
      }
    })
    item.surplus = item.addNum - item.consumeNum
    if (!reg.test(item.email)) {
      dataArr.push(item)
    }
  })
  let surPlusTotal = 0
  dataArr.forEach(x => {
    surPlusTotal += x.surplus
  })
  surPlusTotal = surPlusTotal.toFixed(2)
  let dataTotal = dataArr.length
  console.log(dataArr)
  // dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  res.send({status: 200, total: dataTotal, data: dataArr, surplusTotal: surPlusTotal})
})
_.enhance = function (list, source) {
  return _.map(list, function (element) {
    return _.extend({}, element, source)
  })
}

function getTimeRange ({start, end, key}) {
  if (key === 'date') {
    start = moment(start).startOf('day').format('YYYYMMDD')
    end = moment(end).endOf('day').format('YYYYMMDD')
    return { [key]: {'$gte': start, '$lte': end}
    }
  }
  if (key === 'createdAt') {
    start = moment(start).startOf('day').valueOf()
    end = moment(end).endOf('day').valueOf()
    return {[key]: {'$gte': start, '$lte': end}}
  }
  if (key === 'auditAt') {
    start = moment(start).startOf('day').valueOf()
    end = moment(end).endOf('day').valueOf()
    return {'auditAt': {'$gte': start, '$lte': end}, 'auditStatus': {'$eq': 2}}
  }
}

// 发布公告
app.post('/releaseInfo', async function (req, res) {
  console.log('进入更新公告')
  let body = req.body
  body.time = new Date()
  console.log(body)
  await db.collection('inform').insertOne(body, function (err, rep) {
    if (!err) {
      db.collection('account').update({}, {$set: {inform: true}}, {multi: true})
      res.send({status: 200, message: '更新成功'})
    }
  })
})


// 公告数据
app.post('/getInfo', async function (req, res) {
  console.log('进入公告')
  console.log(req.body)
  let {currentPage, pageSize} = req.body
  let info = await db.collection('inform').find().sort({'createdAt': -1}).toArray()
  let dataArr = []
  info.forEach(x => {
    let item = {}
    item.title = x.title
    item.content = x.content
    item.releaseMen = x.releaseMen
    item.time = moment(x.time).format('YYYY-MM-DD HH:mm:ss')
    dataArr.push(item)
  })
  let dataArrTotal = dataArr.length
  dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  res.send({status: 200, data: dataArr, dataTotal: dataArrTotal})
})

// 运营审核数据
app.post('/checkCall', async function (req, res) {

  console.log('进入了审核')

  let { startTime, endTime, total, pageSize, currentPage, choose} = req.body

  console.log(req.body)

  console.log(choose)

  startTime = moment(startTime).startOf('day').toDate()
  endTime = moment(endTime).endOf('day').toDate()

  console.log(startTime)
  console.log(endTime)
  let comapnyName = await db.collection('account').find({}).sort({'date': -1}).toArray()

  let callName = await db.collection('bills').find({'type': 'dspbuynumber', 'groupID': {$exists: 1}, 'createdAt': {$gt: startTime, $lte: endTime}}).toArray()

  let dspCallGroupsName = await db.collection('dspCallGroups').find().toArray()

  let dataArr = []
  let item = {}
  callName.forEach(x => {
    item.preNum = x.preNum / 3
    if (x.pre === false) {
      item.sendNum = x.number / 3
    } else {
      item.sendNum = 0
    }
    item.time = moment(x.createdAt).format('YYYY-MM-DD HH:mm')
    console.log(item.time)
    comapnyName.forEach(y => {
      if (x.accountID + '' === y._id + '' || x.accountID === y._id) {
        item.companyName = y.company
      }
    })
    dspCallGroupsName.forEach(z => {
      if (x.groupID + '' === z._id + '' || x.groupID === z._id) {
        console.log(z.dspgroup)
        item.name = x._id
        item.groupID = z._id
        item.popover = {}
        if (z.sexlist.length === 1) {
          item.popover.sexlist = z.sexlist
        } else {
          item.popover.sexlist = '不限'
        }
        item.popover.citylist = z.citylist
        item.popover.agelist = z.agelist
        if (z.businesstypelist.length === 3) {
          item.popover.businesstypelist = '不限'
        } else {
          item.popover.businesstypelist = z.businesstypelist
        }
        item.popover.phonelist = z.phonelist
        item.popover.opsystemlist = z.opsystemlist
        item.popover.consumelist = z.consumelist
        item.popover.flowlist = z.flowlist
        item.popover.hobbylist = z.hobbylist

        item.popover.interestlist = z.interestlist
        item.popover.hostlist = z.hostlist
      }
    })
    if (item.popover) {
      if (choose === 'zero' && x.checkStatus === undefined) {
        console.log(choose)
        item.status = '未审核'
        dataArr.push(item)
        item = {}
      }
      if (choose === 'one' && x.checkStatus === 0) {
        console.log(choose)
        item.status = '审核未通过'
        item.disable = true
        dataArr.push(item)
        item = {}
      }
      if (choose === 'two' && (x.checkStatus === 1)) {
        console.log(choose)
        item.status = '审核通过'
        item.disable = true
        dataArr.push(item)
        item = {}
      }
      if (choose === 'all') {
        console.log(choose)
        if (x.checkStatus === undefined) {
          item.status = '未审核'
          item.disable = false
        }
        if (x.checkStatus === 0) {
          item.status = '审核未通过'
          item.disable = true
        }
        if (x.checkStatus === 1) {
          item.status = '审核通过'
          item.disable = true
        }
        // console.log(item)
        dataArr.push(item)
        item = {}
      }
    }
  })
  let dataTotal = dataArr.length
  dataArr = dataArr.reverse()
  dataArr = dataArr.slice((currentPage - 1) * pageSize, currentPage * pageSize)

  res.send({state: 200, data: dataArr, total: dataTotal})
})


// 审核接口
app.post('/send', async function (req, res) {
  console.log('进入send')
  console.log(req.body)
  let {taskId, groupId, interestlist, hostlist, status} = req.body

  if (status === 0) {
    await db.collection('bills').update({'_id': mongodb.ObjectId(taskId)}, {$set: {'checkStatus': 0}})
    res.send({status: 200, message: '审核未通过'})
  }
  if (status === 1) {
    await db.collection('bills').update({'_id': mongodb.ObjectId(taskId)}, {$set: {'checkStatus': 1}})
    await db.collection('dspCallGroups').update({'_id': mongodb.ObjectId(groupId)}, {$set: {'interestlist': interestlist, 'hostlist': hostlist}})
    res.send({status: 200, message: '审核通过'})
  }
})


// 账户数据
app.post('/getAccount', async function (req, res) {
  console.log('进入用户控制')
  console.log(req.body)
  let {currentPage, pageSize} = req.body
  let accounts = await db.collection('account').find().toArray()
  let dataArr = []
  accounts.forEach(x => {
    let item = {}
    if (x.isDelete) {
      item.isAccountDelete = true
    } else {
      item.isAccountDelete = false
    }
    if (x.isCloseAuto) {
      item.isCloseAuto = true
    } else {
      item.isCloseAuto = false
    }
    item._id = x._id
    item.company = x.company
    item.phone = x.phone
    item.email = x.email

    dataArr.push(item)
  })

  let dataArrTotal = dataArr.length
  dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  res.send({status: 200, data: dataArr, dataTotal: dataArrTotal})
})


// 注销接口
app.post('/deleteAccount', async function (req, res) {
  console.log('进入用户控制')
  console.log(req.body)
  let {accountId, status} = req.body
  if (status === 0 || status === '0') {
    await db.collection('account').update({'_id': mongodb.ObjectId(accountId)}, {$set: {'isDelete': true}})
    res.send({status: 200, data: '用户注销成功'})
  }
  if (status === 1 || status === '1') {
    await db.collection('account').update({'_id': mongodb.ObjectId(accountId)}, {$set: {'isDelete': false}})
    res.send({status: 200, data: '用户恢复成功'})
  }
})

//  自动备案接口
app.post('/closeBtn', async function (req, res) {
  console.log('进入自动备案')
  console.log(req.body)
  let {accountId, status} = req.body
  if (status === 0 || status === '0') {
    await db.collection('account').update({'_id': mongodb.ObjectId(accountId)}, {$set: {'isCloseAuto': true}})
    res.send({status: 200, data: '自动备案关闭成功'})
  }
  if (status === 1 || status === '1') {
    await db.collection('account').update({'_id': mongodb.ObjectId(accountId)}, {$set: {'isCloseAuto': false}})
    res.send({status: 200, data: '自动备案开启成功'})
  }
})

app.post('/getSlot', async function (req, res) {
  console.log('进入获取代码位')
  console.log(req.body)

  let {currentPage, pageSize, choose} = req.body

  let company = await db.collection('account').find({}).toArray()

  let slot = await db.collection('slotTemps').find().toArray()

  let dataArr = []
  let emailArr = []

  company.forEach(x => {
    emailArr.push(x.email)
  })
  slot.forEach(x => {
    let item = {}
    item.slotId = x._id
    item.slot = x.durl
    item.slotName = x.slotName
    item.time = moment(x.createdAt).format('YYYY-MM-DD')
    if (x.isSlotDelete) {
      item.isDelete = true
    } else {
      item.isDelete = false
    }
    company.forEach(y => {
      if (x.accountID === y._id || x.accountID + '' === y._id + '') {
        item.company = y.company
        item.email = y.email
      }
    })
    if (choose) {
      if (item.email === choose || item.email + '' === choose + '') {
        dataArr.push(item)
      }
    } else {
    dataArr.push(item)
    }
  })

  let dataTotal = dataArr.length

  dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)

  res.send({status: 200, data: dataArr, dataTotal: dataTotal, emailArr: emailArr})
})

app.post('/deleteSlot', async function (req, res) {
  console.log('进入代码位控制')
  console.log(req.body)
  let {slotId, status} = req.body
  if (status === 0 || status === '0') {
    await db.collection('slotTemps').update({'_id': mongodb.ObjectId(slotId)}, {$set: {'isSlotDelete': true}})
    res.send({status: 200, data: '代码位注销成功'})
  }
  if (status === 1 || status === '1') {
    await db.collection('slotTemps').update({'_id': mongodb.ObjectId(slotId)}, {$set: {'isSlotDelete': false}})
    res.send({status: 200, data: '代码位恢复成功'})
  }
})



module.exports = app
