
import router from '../router/index'

const type = {
  LOGIN: 'LOGIN'
}

const state = {
  sessionID: ''
}

const getters = {
  getSessionID () {
    return state.sessionID
  }
}

const mutations = {
  [type.LOGIN] (state) {
    state.sessionID = sessionStorage.getItem('sessionID')
  }
}

const actions = {
  login ({commit}, {userEmail, password}) {
    console.log(1)
    console.log(userEmail, password)
    if (userEmail && password) {
      fetch('/api/login', {
        method: 'POST',
        headers: {'Content-Type': 'application/json;charset=UTF-8'},
        body: JSON.stringify({userEmail: userEmail, password: password})
      }).then(res => { return res.json() }).then(data => {
        console.log(data)
        if (data.status === 230 || data.message === '登陆成功') {
          console.log('进入commit')
          console.log(data.id)
          sessionStorage.setItem('sessionID', data.id)
          sessionStorage.setItem('email', userEmail)
          commit(type.LOGIN)
          router.push({path: '/'})
        }
      })
    }
  }
}

export default {
  state,
  getters,
  mutations,
  actions
}
