const mongodb = require('mongodb')
const mongoClient = mongodb.MongoClient
const app = require('express').Router()
const _ = require('lodash')
const request = require('request')
const moment = require('moment')
const xlsx = require('node-xlsx')


var dbpath = null

if (process.env.MONGO) {
  dbpath = process.env.MONGO || 'mongodb://10.11.3.127:1301/remarketing'
} else {
  dbpath = 'mongodb://localhost:27017/remarketing'
}


var dbpath_oem = null

if (process.env.MONGO_OEM) {
  dbpath_oem = process.env.MONGO_OEM || 'mongodb://bjwjh-admin:c9yJ2gBFkp7U6@mongo-bjwjh-rs-1.localhost:1302,mongo-bjwjh-rs-2.localhost:1302,mongo-bjwjh-rs-3.localhost:1302/oem_maitian_remarketingAgent?replicaSet=bjwjh-rs&authSource=admin'
} else {
  dbpath_oem = 'mongodb://localhost:27017/remarketing2'
}



var db = {}
var db_oem_mtty = {}
var db_oem_xibao = {}
var db_agent = {}


mongoClient.connect(dbpath,{ useNewUrlParser: true }, function (err, res) {
  
  console.log(process.env.MONGO)
  if (err) return console.log(err)
  
  db = res.db('remarketing')
  db_agent = res.db('remarketingAgent')
})

mongoClient.connect(dbpath_oem, { useNewUrlParser: true }, function (err, res) {

  console.log('---------------')
  console.log(dbpath_oem)
  if (err) return console.log(err)
  if (process.env.MONGO) {
    db_oem_mtty = res.db('oem_mtty_remarketing')
    db_oem_xibao = res.db('oem_xibao_remarketing')
  } else {
    db_oem_mtty = res.db('remarketing2')
    db_oem_xibao = res.db('remarketing3')
    db_agent = res.db('remarketingAgent')
  }
})


// 登陆接口
app.post('/login', async function (req, res) {
  console.log('进入登陆')
  let { userEmail, password } = req.body
  console.log(req.body)
  if (userEmail === 'admin') {
    if (password === 'goyooyunying') {
      res.send({status: 230, message: '登陆成功', id: 'admin'})
    } else {
      res.send({ status: 200, message: '密码错误' })
    }
  } else {
    await db.collection('OEM_account').find({OEM_email: userEmail}).toArray( (err, data) => {
      console.log(data)
      if (data[0].OEM_password === password) {
        res.send({status: 230, id: data[0]._id, message: '登陆成功'})
        // getSession(data[0]._id, res)
      } else {
        res.send({status: 600, message: '密码错误'})
      }
    })
  }
})


// 创建代理商运营账号（备用，可能直接引用代理商账号，同步登陆）
app.post('/creatAgent', async function (req, res) {

  console.log(res.body)

  let { email, password, password2, company } = req.body

  await db.collection('OEM_account').insert({email: email, password: password, company: company}, (err, rep) => {
    if (err) { console.log (err) }
    if (req) {
      res.send({status: 200, message: '创建成功'})
    }
  })

})


// 获取统计数据
app.post('/dataList', async function (req, res) {
  console.log('进入了统计')
  let body = req.body
  let { startTime, endTime, total, pageSize, currentPage } = req.body
  console.log(body)
  console.log(startTime, endTime)

  console.log(db)
  let dateQs = getTimeRange({ start: startTime, end: endTime, key: 'date' })

  let results = await db.collection('dailyStats').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        pv: { $sum: '$pv' },
        uid: { $sum: '$uid' }
      }
    }
  ]).sort({ 'date': -1 }).toArray()

  let touchCount = await db.collection('recognition').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        touchCount: { $sum: 1 }
      }
    }
  ]).sort({ 'date': -1 }).toArray()

  let creatQs = getTimeRange({ start: startTime, end: endTime, key: 'createdAt' })
  console.log(creatQs)

  let msgTask = await db.collection('task').aggregate([
    {
      $match: creatQs
    },
    {
      $group: {
        _id: '$accountID',
        msgCount: { $sum: 1 }
      }
    }]).sort({ 'date': -1 }).toArray()

  let callTask = await db.collection('callTask').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        callCount: { $sum: 1 }
      }
    }]).sort({ 'date': -1 }).toArray()

  let companyName = await db.collection('account').find({ from: { $exists: false }, $or: [{ formID: { $exists: false } }, { formID: { $exists: true, $in: ['self', null] } }], isDelete: {$ne: true} }).sort({ 'date': -1 }).toArray()

  let start = moment(startTime).startOf('day').toDate()
  let end = moment(endTime).endOf('day').toDate()

  let getCount = await db.collection('bills').aggregate([
    {
      $match: {'type': 'audit', 'pre': false, 'createdAt': {$gt: start, $lte: end}}
    },
    {
      $group: {
        _id: '$accountID',
        getCount: { $sum: '$number' }
      }
    }]).sort({ 'date': -1 }).toArray()
    

  let dataArr = []
  

  companyName.forEach(x => {
    let item = {}
    item.time = startTime + ' 至 ' + endTime
    item.company = x.company
    item.email = x.email
    results.forEach(y => {
      if (y._id + '' === x._id + '') {
        item.pv = y.pv
        item.uid = y.uid
      }
    })
    touchCount.forEach(z => {
      if (z._id + '' === x._id + '') {
        item.touchCount = z.touchCount
      }
    })
    getCount.forEach(m => {
      if (m._id + '' === x._id + '') {
        item.getCount = m.getCount / 3
      }
    })
    msgTask.forEach(n => {
      if (n._id + '' === x._id + '') {
        item.msgCount = n.msgCount
      }
    })
    callTask.forEach(o => {
      if (o._id + '' === x._id + '') {
        item.callCount = o.callCount
      }
    })
    // if (item.pv || item.touchCount || item.getCount || item.msgCount || item.callCount) {
    //   dataArr.push(item)
    // }
    // if (!reg.test(item.email)) {
    //   dataArr.push(item)
    // }
    dataArr.push(item)
  })
  let arrTotal = dataArr.length

  // dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  // console.log(dataArr)
  res.send({ status: 200, total: arrTotal, data: dataArr })
})

// 获取渠道数据
app.post('/distributor', async function (req, res) {
  console.log('进入了统计')
  let body = req.body
  let { startTime, endTime, total, pageSize, currentPage } = req.body
  console.log(body)
  console.log(startTime, endTime)

  let dateQs = getTimeRange({ start: startTime, end: endTime, key: 'date' })
  
  let results = await db.collection('dailyStats').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        pv: { $sum: '$pv' },
        uid: { $sum: '$uid' }
      }
    }
  ]).sort({ 'date': -1 }).toArray()

  let touchCount = await db.collection('recognition').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        touchCount: { $sum: 1 }
      }
    }
  ]).sort({ 'date': -1 }).toArray()

  let creatQs = getTimeRange({ start: startTime, end: endTime, key: 'createdAt' })
  console.log(creatQs)

  let msgTask = await db.collection('task').aggregate([
    {
      $match: creatQs
    },
    {
      $group: {
        _id: '$accountID',
        msgCount: { $sum: 1 }
      }
    }]).sort({ 'date': -1 }).toArray()

  let callTask = await db.collection('callTask').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        callCount: { $sum: 1 }
      }
    }]).sort({ 'date': -1 }).toArray()

  let companyName = await db.collection('account').find({ fromID: { $exists: true, $nin: ['self', null] }, isDelete: {$ne: true} }).sort({ 'date': -1 }).toArray()

  let auditDate = getTimeRange({ start: startTime, end: endTime, key: 'auditAt' })

  let getCount = await db.collection('recognition').aggregate([
    {
      $match: auditDate
    },
    {
      $group: {
        _id: '$pubID',
        getCount: { $sum: 1 }
      }
    }]).sort({ 'date': -1 }).toArray()

  let dataArr = []
  

  companyName.forEach(x => {
    let item = {}
    item.time = startTime + ' 至 ' + endTime
    item.company = x.company
    item.email = x.email
    item.distributor = x.from
    results.forEach(y => {
      if (y._id + '' === x._id + '') {
        item.pv = y.pv
        item.uid = y.uid
      }
    })
    touchCount.forEach(z => {
      if (z._id + '' === x._id + '') {
        item.touchCount = z.touchCount
      }
    })
    getCount.forEach(m => {
      if (m._id + '' === x._id + '') {
        item.getCount = m.getCount
      }
    })
    msgTask.forEach(n => {
      if (n._id + '' === x._id + '') {
        item.msgCount = n.msgCount
      }
    })
    callTask.forEach(o => {
      if (o._id + '' === x._id + '') {
        item.callCount = o.callCount
      }
    })
    // if (item.pv || item.touchCount || item.getCount || item.msgCount || item.callCount) {
    //   dataArr.push(item)
    // }
    // if (!reg.test(item.email)) {
    //   dataArr.push(item)
    // }
    dataArr.push(item)
    
  })
  let arrTotal = dataArr.length

  // dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  // console.log(dataArr)
  res.send({ status: 200, total: arrTotal, data: dataArr })
})


// 消费数据
app.post('/consume', async function (req, res) {
  console.log('进入了消费')

  let { startTime, endTime, total, pageSize, currentPage } = req.body

  startTime = moment(startTime).startOf('day').toDate()
  endTime = moment(endTime).endOf('day').toDate()

  console.log(startTime)
  console.log(endTime)

  let counsume = await db.collection('bills').aggregate([
    {
      $match: { createdAt: { $gt: startTime, $lte: endTime } }
    },
    {
      $group: {
        _id: { accountID: '$accountID', pre: '$pre' },
        number: { $sum: '$number' }
      }
    }]).toArray()

  console.log(counsume)

  let companyName = await db.collection('account').find({isDelete: {$ne: true}}).sort({ 'date': -1 }).toArray()

  let data = []
  let preData = []
  for (let i = 0; i < counsume.length; i++) {
    if (counsume[i]._id.pre === true) {
      preData.push({ _id: counsume[i]._id.accountID, preNumber: counsume[i].number })
    } else {
      data.push({ _id: counsume[i]._id.accountID, number: counsume[i].number })
    }
  }
  
  startTime = moment(startTime).startOf('day').format('YYYY-MM-DD')
  endTime = moment(endTime).endOf('day').format('YYYY-MM-DD')

  let dataArr = []
  
  companyName.forEach(x => {
    let item = {}
    item.time = startTime + ' 至 ' + endTime
    item.company = x.company
    item.email = x.email
    data.forEach(y => {
      if (x._id + '' === y._id + '' || x._id === y._id) {
        item.number = y.number
      }
    })
    preData.forEach(z => {
      if (z._id + '' === x._id + '' || z._id === x._id) {
        item.preNumber = z.preNumber
      }
    })
    // if (item.number || item.preNumber) {
    //   dataArr.push(item)
    // }
    // if (!reg.test(item.email)) {
    //   dataArr.push(item)
    // }
    dataArr.push(item)
  })
  let dataTotal = dataArr.length


  let preTotalNumber = 0
  let consumeTotalNumber = 0
  dataArr.forEach(x => {
    if (typeof (x.number) === 'number') {
      consumeTotalNumber += x.number
    }
    if (typeof (x.preNumber) === 'number') {
      preTotalNumber += x.preNumber
    }
  })
  console.log(consumeTotalNumber)
  console.log(preTotalNumber)
  // dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  res.send({ status: 200, consumeTotalNumber: consumeTotalNumber, preTotalNumber: preTotalNumber, total: dataTotal, data: dataArr })
})

// 充值数据
app.post('/finance', async function (req, res) {
  console.log('进入充值')

  console.log(req.body)

  let { startTime, endTime, total, pageSize, currentPage } = req.body

  startTime = moment('2018-01-01').startOf('day').toDate()
  endTime = moment(endTime).endOf('day').toDate()
  console.log(startTime)
  console.log(endTime)

  let finance = await db.collection('recharge').aggregate([
    {
      $match: { createdAt: { $gt: startTime, $lte: endTime } }
    },
    {
      $group: {
        _id: '$accountID',
        number: { $sum: '$number' }
      }
    }]).toArray()

  let companyName = await db.collection('account').find({isDelete: {$ne: true}}).sort({ 'date': -1 }).toArray()

  startTime = moment(startTime).startOf('day').format('YYYY-MM-DD')
  endTime = moment(endTime).startOf('day').format('YYYY-MM-DD')

  let dataArr = []
  
  companyName.forEach(x => {
    let item = {}
    item.time = startTime + ' 至 ' + endTime
    item.company = x.company
    item.email = x.email
    finance.forEach(y => {
      if (x._id + '' === y._id + '') {
        item.number = y.number
      }
    })
    // if (item.number) {
    //   dataArr.push(item)
    // }

    // if (!reg.test(item.email)) {
    //   dataArr.push(item)
    // }
      dataArr.push(item)
  })
  let dataTolal = dataArr.length

  let financeNumber = 0
  console.log(financeNumber)
  for (let i = 0; i < dataArr.length; i++) {
    if (dataArr[i].number) {
      financeNumber += dataArr[i].number
    }
  }
  financeNumber = financeNumber.toFixed(2)
  // dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)

  res.send({ status: 200, financeNumber: financeNumber, total: dataTolal, data: dataArr })
})


// 余额数据
app.post('/surplus', async function (req, res) {
  console.log('进入了余额')

  let { startTime, endTime, total, pageSize, currentPage } = req.body

  startTime = moment('2018-01-01').startOf('day').toDate()
  endTime = moment(endTime).endOf('day').toDate()
  console.log(startTime)
  console.log(endTime)

  let consume = await db.collection('bills').aggregate([
    {
      $match: { createdAt: { $gt: startTime, $lte: endTime } }
    },
    {
      $group: {
        _id: '$accountID',
        number: { $sum: '$number' }
      }
    }]).toArray()

  let add = await db.collection('recharge').aggregate([
    {
      $group: {
        _id: '$accountID',
        number: { $sum: '$number' }
      }
    }]).toArray()


  let companyName = await db.collection('account').find({isDelete: {$ne: true}}).sort({ 'date': -1 }).toArray()


  let dataArr = []
  startTime = moment(startTime).startOf('day').format('YYYY-MM-DD')
  endTime = moment(endTime).startOf('day').format('YYYY-MM-DD')
  companyName.forEach(x => {
    let item = {}
    item.time = '截至' + endTime
    item.createdAt = moment(x.createdAt).format('YYYY-MM-DD')
    item.company = x.company
    item.email = x.email
    item.consumeNum = 0
    item.addNum = 0
    consume.forEach(y => {
      if (x._id + '' === y._id + '' || x._id === y._id) {
        if (typeof (y.number) === 'number') {
          item.consumeNum = y.number
        } else {
          item.consumeNum = 0
        }
      }
    })
    add.forEach(z => {
      if (x._id + '' === z._id + '' || x._id === z._id) {
        if (typeof (z.number) === 'number') {
          item.addNum = z.number
        } else {
          item.consumeNum = 0
        }
      }
    })
    item.surplus = item.addNum - item.consumeNum
    // if (!reg.test(item.email)) {
    //   dataArr.push(item)
    // }
    dataArr.push(item)
  })
  let surPlusTotal = 0
  dataArr.forEach(x => {
    surPlusTotal += x.surplus
  })
  surPlusTotal = surPlusTotal.toFixed(2)
  let dataTotal = dataArr.length
  // console.log(dataArr)
  // dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  res.send({ status: 200, total: dataTotal, data: dataArr, surplusTotal: surPlusTotal })
})

function getTimeRange({ start, end, key }) {
  if (key === 'date') {
    start = moment(start).startOf('day').format('YYYYMMDD')
    end = moment(end).endOf('day').format('YYYYMMDD')
    return {
      [key]: { '$gte': start, '$lte': end }
    }
  }
  if (key === 'createdAt') {
    start = moment(start).startOf('day').valueOf()
    end = moment(end).endOf('day').valueOf()
    return { [key]: { '$gte': start, '$lte': end } }
  }
  if (key === 'auditAt') {
    start = moment(start).startOf('day').valueOf()
    end = moment(end).endOf('day').valueOf()
    return { 'auditAt': { '$gte': start, '$lte': end }, 'auditStatus': { '$eq': 2 } }
  }
}

// 发布公告
app.post('/releaseInfo', async function (req, res) {
  console.log('进入更新公告')
  let {title, content, releaseMen, sessionID} = req.body

  let time = new Date()

  await db.collection('inform').insertOne({title: title, content: content, releaseMen: releaseMen, time: time}, function (err, rep) {
    if (!err) {
      db.collection('account').update({}, { $set: { inform: true } }, { multi: true })
      res.send({ status: 200, message: '更新成功' })
    } else {
      res.send({ status: 500, message: '更新失败' })
    }
  })
})


// 公告数据
app.post('/getInfo', async function (req, res) {
  console.log('进入公告')
  console.log(req.body)
  let { currentPage, pageSize, sessionID} = req.body

  console.log(db)

  let info = await db.collection('inform').find().sort({ 'createdAt': -1 }).toArray()

  let dataArr = []
  info.forEach(x => {
    let item = {}
    item.title = x.title
    item.content = x.content
    item.releaseMen = x.releaseMen
    item.time = moment(x.time).format('YYYY-MM-DD HH:mm:ss')
    dataArr.push(item)
  })

  let dataArrTotal = dataArr.length
  dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  res.send({ status: 200, data: dataArr, dataTotal: dataArrTotal })
})

// 云呼审核数据
app.post('/checkCall', async function (req, res) {

  console.log('进入了审核')

  let { startTime, endTime, total, pageSize, currentPage, choose, sessionID} = req.body

  console.log(req.body)

  startTime = moment(startTime).startOf('day').toDate()
  endTime = moment(endTime).endOf('day').toDate()

  console.log(startTime)
  console.log(endTime)

  // 获取remarketing数据库数据
  
  let companyName = await db.collection('account').find({}).sort({ 'date': -1 }).toArray()

  let callName = await db.collection('bills').find({ 'type': 'dspbuynumber', 'groupID': { $exists: 1 }, 'createdAt': { $gt: startTime, $lte: endTime } }).toArray()

  let dspCallGroupsName = await db.collection('dspCallGroups').find().toArray()
  
  let agent = await db_agent.collection('account').find({}).toArray()

  let dataArr = []
  callName.forEach(x => {
    let item = {}
    item.oem = '微聚合'
    item.preNum = x.preNum / 3
    if (x.pre === false) {
      item.sendNum = x.number / 3
    } else {
      item.sendNum = 0
    }
    item.time = moment(x.createdAt).format('YYYY-MM-DD HH:mm')

    companyName.forEach(y => {
      if (x.accountID + '' === y._id + '' || x.accountID === y._id) {
        item.companyName = y.company
        if (y.fromID) {
          agent.forEach(m => {
            if (y.fromID === m._id || y.fromID + '' === m._id + '' ) {
              item.agent = m.company
              item.agentEmail = m.email
            }
          })
        }
      }
    })

    dspCallGroupsName.forEach(z => {
      if (x.groupID + '' === z._id + '' || x.groupID === z._id) {
        
        item.name = x._id
        item.groupID = z._id
        item.popover = {}
        if (z.sexlist.length === 1) {
          item.popover.sexlist = z.sexlist
        } else {
          item.popover.sexlist = '不限'
        }
        item.popover.citylist = z.citylist
        item.popover.agelist = z.agelist
        if (z.businesstypelist.length === 3) {
          item.popover.businesstypelist = '不限'
        } else {
          item.popover.businesstypelist = z.businesstypelist
        }
        item.popover.phonelist = z.phonelist
        item.popover.opsystemlist = z.opsystemlist
        item.popover.consumelist = z.consumelist
        item.popover.flowlist = z.flowlist
        item.popover.hobbylist = z.hobbylist
        item.popover.meta = z.meta
        item.popover.interestlist = z.interestlist
        item.popover.hostlist = z.hostlist
        if (z.applist) {
          item.popover.applist = z.applist
        }
      }
    })
    if (item.popover) {
      if (choose === 'zero' && x.checkStatus === undefined) {
        
        item.status = '未审核'
        dataArr.push(item)
        item = {}
      }
      if (choose === 'one' && x.checkStatus === 0) {
        
        item.status = '审核未通过'
        item.disable = true
        dataArr.push(item)
        item = {}
      }
      if (choose === 'two' && x.checkStatus === 1) {
        
        item.status = '审核通过'
        item.disable = true
        dataArr.push(item)
        item = {}
      }
      if (choose === 'all') {
        
        if (x.checkStatus === undefined) {
          item.status = '未审核'
          item.disable = false
        }
        if (x.checkStatus === 0) {
          item.status = '审核未通过'
          item.disable = true
        }
        if (x.checkStatus === 1) {
          item.status = '审核通过'
          item.disable = true
        }
        // console.log(item)
        dataArr.push(item)
      }
    }
  })


  //  获取麦田
  let oem_mtty_companyName = await db_oem_mtty.collection('account').find({}).sort({ 'date': -1 }).toArray()

  let oem_mtty_callName = await db_oem_mtty.collection('bills').find({ 'type': 'dspbuynumber', 'groupID': { $exists: 1 }, 'createdAt': { $gt: startTime, $lte: endTime }, 'oemCheckStatus': 1}).toArray()

  let oem_mtty_dspCallGroupsName = await db_oem_mtty.collection('dspCallGroups').find().toArray()


  
  oem_mtty_callName.forEach(x => {
    let item = {}
    item.oem = x.oem
    item.preNum = x.preNum / 3
    if (x.pre === false) {
      item.sendNum = x.number / 3
    } else {
      item.sendNum = 0
    }
    item.time = moment(x.createdAt).format('YYYY-MM-DD HH:mm')
    
    oem_mtty_companyName.forEach(y => {
      if (x.accountID + '' === y._id + '' || x.accountID === y._id) {
        item.companyName = y.company
      }
    })
    oem_mtty_dspCallGroupsName.forEach(z => {
      if (x.groupID + '' === z._id + '' || x.groupID === z._id) {
        
        item.name = x._id
        item.groupID = z._id
        item.popover = {}
        if (z.sexlist.length === 1) {
          item.popover.sexlist = z.sexlist
        } else {
          item.popover.sexlist = '不限'
        }
        item.popover.citylist = z.citylist
        item.popover.agelist = z.agelist
        if (z.businesstypelist.length === 3) {
          item.popover.businesstypelist = '不限'
        } else {
          item.popover.businesstypelist = z.businesstypelist
        }
        item.popover.phonelist = z.phonelist
        item.popover.opsystemlist = z.opsystemlist
        item.popover.consumelist = z.consumelist
        item.popover.flowlist = z.flowlist
        item.popover.hobbylist = z.hobbylist
        item.popover.meta = z.meta
        item.popover.interestlist = z.interestlist
        item.popover.hostlist = z.hostlist
        if (z.applist) {
          item.popover.applist = z.applist
        }
      }
    })
    if (item.popover) {
      if (choose === 'zero' && x.checkStatus === undefined) {
        
        item.status = '未审核'
        dataArr.push(item)
      }
      if (choose === 'one' && x.checkStatus === 0) {
        
        item.status = '审核未通过'
        item.disable = true
        dataArr.push(item)
      }
      if (choose === 'two' && x.checkStatus === 1) {
        
        item.status = '审核通过'
        item.disable = true
        dataArr.push(item)
      }
      if (choose === 'all') {
        
        if (x.checkStatus === undefined) {
          item.status = '未审核'
          item.disable = false
        }
        if (x.checkStatus === 0) {
          item.status = '审核未通过'
          item.disable = true
        }
        if (x.checkStatus === 1) {
          item.status = '审核通过'
          item.disable = true
        }
        dataArr.push(item)
      }
    }
  })


// 获取喜宝

  let oem_xibao_companyName = await db_oem_xibao.collection('account').find({}).sort({ 'date': -1 }).toArray()

  let oem_xibao_callName = await db_oem_xibao.collection('bills').find({ 'type': 'dspbuynumber', 'groupID': { $exists: 1 }, 'createdAt': { $gt: startTime, $lte: endTime }, 'oemCheckStatus': 1}).toArray()

  let oem_xibao_dspCallGroupsName = await db_oem_xibao.collection('dspCallGroups').find().toArray()


  
  oem_xibao_callName.forEach(x => {
    let item = {}
    item.oem = x.oem
    item.preNum = x.preNum / 3
    if (x.pre === false) {
      item.sendNum = x.number / 3
    } else {
      item.sendNum = 0
    }
    item.time = moment(x.createdAt).format('YYYY-MM-DD HH:mm')
    
    oem_xibao_companyName.forEach(y => {
      if (x.accountID + '' === y._id + '' || x.accountID === y._id) {
        item.companyName = y.company
      }
    })
    oem_xibao_dspCallGroupsName.forEach(z => {
      if (x.groupID + '' === z._id + '' || x.groupID === z._id) {
        
        item.name = x._id
        item.groupID = z._id
        item.popover = {}
        if (z.sexlist.length === 1) {
          item.popover.sexlist = z.sexlist
        } else {
          item.popover.sexlist = '不限'
        }
        item.popover.citylist = z.citylist
        item.popover.agelist = z.agelist
        if (z.businesstypelist.length === 3) {
          item.popover.businesstypelist = '不限'
        } else {
          item.popover.businesstypelist = z.businesstypelist
        }
        item.popover.phonelist = z.phonelist
        item.popover.opsystemlist = z.opsystemlist
        item.popover.consumelist = z.consumelist
        item.popover.flowlist = z.flowlist
        item.popover.hobbylist = z.hobbylist
        item.popover.meta = z.meta
        item.popover.interestlist = z.interestlist
        item.popover.hostlist = z.hostlist
        if (z.applist) {
          item.popover.applist = z.applist
        }
      }
    })
    if (item.popover) {
      if (choose === 'zero' && x.checkStatus === undefined) {
        
        item.status = '未审核'
        dataArr.push(item)
      }
      if (choose === 'one' && x.checkStatus === 0) {
        
        item.status = '审核未通过'
        item.disable = true
        dataArr.push(item)
      }
      if (choose === 'two' && x.checkStatus === 1) {
        
        item.status = '审核通过'
        item.disable = true
        dataArr.push(item)
      }
      if (choose === 'all') {
        
        if (x.checkStatus === undefined) {
          item.status = '未审核'
          item.disable = false
        }
        if (x.checkStatus === 0) {
          item.status = '审核未通过'
          item.disable = true
        }
        if (x.checkStatus === 1) {
          item.status = '审核通过'
          item.disable = true
        }
        dataArr.push(item)
      }
    }
  })





  let dataTotal = dataArr.length
  dataArr = dataArr.reverse()
  dataArr = dataArr.slice((currentPage - 1) * pageSize, currentPage * pageSize)

  res.send({ state: 200, data: dataArr, total: dataTotal })
})

// 云呼审核接口
app.post('/send', async function (req, res) {
  console.log('进入send')
  console.log(req.body)

  let {taskId, groupId, interestlist, hostlist, applist, status, oem} = req.body

  if (status === 8) {
    if (oem === '微聚合' || oem === null || oem === undefined) {
      await db.collection('bills').update({ '_id': mongodb.ObjectId(taskId) }, { $unset: { 'checkStatus': '' } })
    } else if (oem === '麦田'){
      await db_oem_mtty.collection('bills').update({ '_id': mongodb.ObjectId(taskId) }, { $unset: { 'checkStatus': '' } })
    } else {
      await db_oem_xibao.collection('bills').update({ '_id': mongodb.ObjectId(taskId) }, { $unset: { 'checkStatus': '' } })
    }
    res.send({ status: 202, message: '状态已重置' })
  }


  if (status === 0) {
    if (oem === '微聚合' || oem === null || oem === undefined) {
      await db.collection('bills').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 0, pre: false, number: 0 } })
    } else if (oem === '麦田'){
      await db_oem_mtty.collection('bills').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 0, pre: false, number: 0 } })
    } else {
      await db_oem_xibao.collection('bills').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 0, pre: false, number: 0 } })
    }
    res.send({ status: 201, message: '审核未通过' })
  }


  if (status === 1) {
    let updateTime = new Date()
    if (oem === '微聚合' || oem === null || oem === undefined) {
      await db.collection('bills').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 1 , 'checkTime': updateTime} })
      await db.collection('dspCallGroups').update({ '_id': mongodb.ObjectId(groupId) }, { $set: { 'interestlist': interestlist, 'hostlist': hostlist, 'applist': applist } })
    } else if (oem === '麦田'){
      await db_oem_mtty.collection('bills').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 1, 'checkTime': updateTime} })
      await db_oem_mtty.collection('dspCallGroups').update({ '_id': mongodb.ObjectId(groupId) }, { $set: { 'interestlist': interestlist, 'hostlist': hostlist , 'applist': applist} })
    } else {
      await db_oem_xibao.collection('bills').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 1, 'checkTime': updateTime } })
      await db_oem_xibao.collection('dspCallGroups').update({ '_id': mongodb.ObjectId(groupId) }, { $set: { 'interestlist': interestlist, 'hostlist': hostlist, 'applist': applist } })
    }
    
    
    res.send({ status: 200, message: '审核通过' })
  }
})

// 获取行业标签
app.post('/getTag', async function (req, res) {
  console.log('进入tag')
  console.log(req.body)

  let { oneChoose } = req.body

  let onelevel = {}
  let twolevel = {}
  let twoOK = {}
  function getXlsx () {
    var obj = xlsx.parse(__dirname+'/hangye.xlsx');
    var excelObj=obj[0].data;
    
    var data = [];
    for(var i in excelObj){
        var arr=[];
        var value=excelObj[i];
        var obj = {}
        for(var j in value){
            if (value[j]) {
                data.push(value[j]);
            }
        }
    }
    for (var x = 4; x < data.length; x++) { 
      if (x % 2 === 0) {
        if (data[x] < 30) {
            onelevel[data[x]] = data[x + 1]
        } else {
            twolevel[data[x]] = data[x + 1]
        }
      }
    }
  }
  getXlsx()
  


console.log(twoOK)
res.send({status: 200, onelevel: onelevel, twolevel: twolevel, twoOK: twoOK})
})

// 短信审核信息
app.post('/getCheckNote', async function (req, res) {

  console.log('进入了getData')

  let { startTime, endTime, total, pageSize, currentPage, chooseId, operatorId, sessionID} = req.body
  
  console.log(req.body)
  console.log(chooseId)

  startTime = moment(startTime).startOf('day').toDate()
  endTime = moment(endTime).endOf('day').toDate()

  // 获取remarketing数据库

  console.log(startTime)
  console.log(endTime)
  let companyName = await db.collection('account').find({}).sort({ 'date': -1 }).toArray()

  let msgTagName = await db.collection('msgTemps').find().sort({ 'date': -1 }).toArray()

  let dspGroupsName = await db.collection('dspGroups').find().sort({ 'date': -1 }).toArray()

  let dspTask = await db.collection('dspTask').find({ 'createdAt': { $gte: startTime, $lte: endTime } }).sort({ 'date': 1 }).toArray()

  let agent = await db_agent.collection('account').find({}).toArray()

  let dataArr = []
  dspTask.forEach(x => {
    let item = {}
    item.taskID = x._id
    item.oem = '微聚合'
    item.taskName = x.taskName
    item.accountID = x.accountID
    item.sendTime = moment(x.sendTime).format('YYYY-MM-DD HH:mm:ss')
    item.preSendNum = x.nums
    if (x.sendNum === null) {
      item.sendNum = 0
    } else {
      item.sendNum = x.sendNum
    }
    item.createdAt = moment(x.createdAt).format('YYYY-MM-DD HH:mm:ss')
    companyName.forEach(y => {
      if (x.accountID + '' === y._id + '') {
        item.companyName = y.company
        if (y.fromID) {
          agent.forEach(m => {
            if (y.fromID === m._id || y.fromID + '' === m._id + '' ) {
              item.agent = m.company
              item.agentEmail = m.email
            }
          })
        }
      }
    })
    msgTagName.forEach(z => {
      if (x.templateId + '' === z._id + '' && x.accountID + '' === z.accountID + '') {
        item.msgName = z.name
        item.msgContent = z.content
      }
    })
    dspGroupsName.forEach(m => {
        
      if (x.groupID + '' === m._id + '' && x.accountID === m.accountID) {
        item.groupID = m._id
        item.popover = {
          sexlist: m.sexlist,
          agelist: m.agelist,
          businesstypelist: m.businesstypelist,
          phonelist: m.phonelist,
          opsystemlist: m.opsystemlist,
          consumelist: m.consumelist,
          flowlist: m.flowlist,
          citylist: m.citylist,
          hobbylist: m.hobbylist
        }
        if (m.operator) {
          item.popover.operator = m.operator
        }
        if (m.interestlist) {
          item.popover.interestlist = m.interestlist
        }
        if (m.hostlist) {
          item.popover.hostlist = m.hostlist
        }
        if (m.applist) {
          item.popover.applist = m.applist
        }
        
          item.popover.meta = m.meta || '无'
        
      }
    })
    if (operatorId + '' === '联通' + '' && (item.popover.operator === undefined || item.popover.operator === '联通' + '')) {
      if (x.checkStatus === 0) {
        item.status = '审核未通过'
        item.disable = true
      } else if (x.checkStatus === 1) {
        item.status = '审核通过'
        item.disable = true
      } else {
        item.status = '未审核'
        item.disable = false
      }
      dataArr.push(item)
    } else {
      if (item.popover.operator + '' === operatorId + '') {
        if (x.status === 0 || x.status === undefined) {
          item.status = '未审核'
          item.disable = false
        }
        if (x.status === 1) {
          item.status = '审核未通过'
          item.disable = true
        }
        if (x.status === 2) {
          item.status = '审核通过'
          item.disable = true
        }
        dataArr.push(item)
      }
    }
  })

  // 获取麦田

  let oem_mtty_companyName = await db_oem_mtty.collection('account').find({}).sort({ 'date': -1 }).toArray()

  let oem_mtty_msgTagName = await db_oem_mtty.collection('msgTemps').find().sort({ 'date': -1 }).toArray()

  let oem_mtty_dspGroupsName = await db_oem_mtty.collection('dspGroups').find().sort({ 'date': -1 }).toArray()

  let oem_mtty_dspTask = await db_oem_mtty.collection('dspTask').find({ 'createdAt': { $gte: startTime, $lte: endTime }, 'oemCheckStatus': 1 }).sort({ 'date': -1 }).toArray()
  
  oem_mtty_dspTask.forEach(x => {
    let item = {}
    item.taskID = x._id
    item.oem = x.oem || '麦田'
    item.taskName = x.taskName
    item.accountID = x.accountID
    item.sendTime = moment(x.sendTime).format('YYYY-MM-DD HH:mm:ss')
    item.preSendNum = x.nums
    if (x.sendNum === null) {
      item.sendNum = 0
    } else {
      item.sendNum = x.sendNum
    }
    item.createdAt = moment(x.createdAt).format('YYYY-MM-DD HH:mm:ss')
    oem_mtty_companyName.forEach(y => {
      if (x.accountID + '' === y._id + '') {
        item.companyName = y.company
      }
    })
    oem_mtty_msgTagName.forEach(z => {
      if (x.templateId + '' === z._id + '' && x.accountID + '' === z.accountID + '') {
        item.msgName = z.name
        item.msgContent = z.content
      }
    })
    oem_mtty_dspGroupsName.forEach(m => {
      if (x.groupID + '' === m._id + '') {
        item.groupID = m._id
        // console.log(m)
        item.popover = {
          sexlist: m.sexlist,
          agelist: m.agelist,
          businesstypelist: m.businesstypelist,
          phonelist: m.phonelist,
          opsystemlist: m.opsystemlist,
          consumelist: m.consumelist,
          flowlist: m.flowlist,
          citylist: m.citylist,
          hobbylist: m.hobbylist
        }
        
        if (m.operator) {
          item.popover.operator = m.operator
        }
        
        if (m.interestlist) {
          item.popover.interestlist = m.interestlist
        }
        
        if (m.hostlist) {
          item.popover.hostlist = m.hostlist
        }
        
        if (m.applist) {
          item.popover.applist = m.applist
        }

          item.popover.meta = m.meta || '无'
        
      }
    })
    if (operatorId + '' === '联通' + '' && (item.popover.operator === undefined || item.popover.operator === '联通' + '')) {
      if (x.checkStatus === 0) {
        item.status = '审核未通过'
        item.disable = true
      } else if (x.checkStatus === 1) {
        item.status = '审核通过'
        item.disable = true
      } else {
        item.status = '未审核'
        item.disable = false
      }
      dataArr.push(item)
    } else {
      if (item.popover.operator + '' === operatorId + '') {
        if (x.status === 0 || x.status === undefined) {
          item.status = '未审核'
          item.disable = false
        }
        if (x.status === 1) {
          item.status = '审核未通过'
          item.disable = true
        }
        if (x.status === 2) {
          item.status = '审核通过'
          item.disable = true
        }
        dataArr.push(item)
      }
    }
  })
  //  获取喜宝

  let oem_xibao_companyName = await db_oem_xibao.collection('account').find({}).sort({ 'date': -1 }).toArray()

  let oem_xibao_msgTagName = await db_oem_xibao.collection('msgTemps').find().sort({ 'date': -1 }).toArray()

  let oem_xibao_dspGroupsName = await db_oem_xibao.collection('dspGroups').find().sort({ 'date': -1 }).toArray()

  let oem_xibao_dspTask = await db_oem_xibao.collection('dspTask').find({ 'createdAt': { $gte: startTime, $lte: endTime }, 'oemCheckStatus': 1 }).sort({ 'date': 1 }).toArray()

  
  oem_xibao_dspTask.forEach(x => {
    let item = {}
    item.taskID = x._id
    item.oem = x.oem || '喜宝'
    item.taskName = x.taskName
    item.accountID = x.accountID
    item.sendTime = moment(x.sendTime).format('YYYY-MM-DD HH:mm:ss')
    item.preSendNum = x.nums
    if (x.sendNum === null) {
      item.sendNum = 0
    } else {
      item.sendNum = x.sendNum
    }
    item.createdAt = moment(x.createdAt).format('YYYY-MM-DD HH:mm:ss')
    oem_xibao_companyName.forEach(y => {
      if (x.accountID + '' === y._id + '') {
        item.companyName = y.company
      }
    })
    oem_xibao_msgTagName.forEach(z => {
      if (x.templateId + '' === z._id + '' && x.accountID + '' === z.accountID + '') {
        item.msgName = z.name
        item.msgContent = z.content
      }
    })
    oem_xibao_dspGroupsName.forEach(m => {
      
      if (x.groupID + '' === m._id + '' && x.accountID === m.accountID) {
        item.groupID = m._id
        item.popover = {
          sexlist: m.sexlist,
          agelist: m.agelist,
          businesstypelist: m.businesstypelist,
          phonelist: m.phonelist,
          opsystemlist: m.opsystemlist,
          consumelist: m.consumelist,
          flowlist: m.flowlist,
          citylist: m.citylist,
          hobbylist: m.hobbylist
        }
        if (m.operator) {
          item.popover.operator = m.operator
        }
        if (m.interestlist) {
          item.popover.interestlist = m.interestlist
        }
        if (m.hostlist) {
          item.popover.hostlist = m.hostlist
        }
        if (m.applist) {
          item.popover.applist = m.applist
        }
        
          item.popover.meta = m.meta || '无'
        
      }
    })
    if (operatorId + '' === '联通' + '' && (item.popover.operator === undefined || item.popover.operator === '联通' + '')) {
      if (x.checkStatus === 0) {
        item.status = '审核未通过'
        item.disable = true
      } else if (x.checkStatus === 1) {
        item.status = '审核通过'
        item.disable = true
      } else {
        item.status = '未审核'
        item.disable = false
      }
      dataArr.push(item)
    } else {
      if (item.popover.operator + '' === operatorId + '') {
        if (x.status === 0 || x.status === undefined) {
          item.status = '未审核'
          item.disable = false
        }
        if (x.status === 1) {
          item.status = '审核未通过'
          item.disable = true
        }
        if (x.status === 2) {
          item.status = '审核通过'
          item.disable = true
        }
        dataArr.push(item)
      }
    }
  })

  dataArr = dataArr.reverse()
  let dataStatus = []
  let dataTotal = dataArr.length
  if (chooseId === 'zero') {
    console.log('进入zero')
    dataArr.forEach(x => {
      if (x.status === '未审核') {
        console.log('zero')
        dataStatus.push(x)
        dataStatus = dataStatus.slice((currentPage - 1) * pageSize, currentPage * pageSize)
      }
    })
    res.send({ status: 200, data: dataStatus, total: dataTotal })
  }
  if (chooseId === 'one') {
    dataArr.forEach(x => {
      if (x.status === '审核未通过') {
        console.log('one')
        dataStatus.push(x)
        dataStatus = dataStatus.slice((currentPage - 1) * pageSize, currentPage * pageSize)
      }
    })
    console.log(dataStatus)
    res.send({ status: 200, data: dataStatus, total: dataTotal })
  }
  if (chooseId === 'two') {
    dataArr.forEach(x => {
      if (x.status === '审核通过') {
        console.log('two')
        dataStatus.push(x)
        dataStatus = dataStatus.slice((currentPage - 1) * pageSize, currentPage * pageSize)
      }
    })
    res.send({ status: 200, data: dataStatus, total: dataTotal })
  }
  if (chooseId === 'all') {
    dataArr = dataArr.slice((currentPage - 1) * pageSize, currentPage * pageSize)
    res.send({ status: 200, data: dataArr, total: dataTotal })
  }
})

// 向短信打标签 
app.post('/creatNoteTag', async function (req, res) {
  console.log(req.body)
  let {groupID, interestlist, hostlist, applist, oem} = req.body

  if (oem === '微聚合' || oem === null || oem === undefined) {
    await db.collection('dspGroups').update({_id: mongodb.ObjectId(groupID)}, {$set: {interestlist: interestlist, hostlist: hostlist, applist: applist}})
  } else if (oem === '麦田') {
    await db_oem_mtty.collection('dspGroups').update({_id: mongodb.ObjectId(groupID)}, {$set: {interestlist: interestlist, hostlist: hostlist, applist: applist}})
  } else {
    await db_oem_xibao.collection('dspGroups').update({_id: mongodb.ObjectId(groupID)}, {$set: {interestlist: interestlist, hostlist: hostlist, applist: applist}})
  }
  res.send({status: 200, data: 'OK'})
})

// 短信审核
app.post('/sendCheckNote', async function (req, res) {
  console.log('进入send')
  console.log(req.body)
  let { taskId, status, sendNum, operatorId, oem} = req.body

  if (status === 8) {
    db.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'status': 0 } })
    res.send({ status: 203, message: '状态已重置' })
  }

  if (operatorId === '联通' || operatorId === null || operatorId === undefined) {
    await db.collection('dspTask').find({ '_id': mongodb.ObjectId(taskId) }).toArray(async (err, rep) => {
      if (status === 1) {
        if (oem === '微聚合' || oem === null || oem === undefined) {
          await db.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 0 } })
          await db.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'status': 1 } })
          await db.collection('bills').update({ taskID: mongodb.ObjectId(taskId), pre: true }, { $set: { pre: false, number: 0 } })
        } else if (oem === '麦田') {
          await db_oem_mtty.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 0 } })
          await db_oem_mtty.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'status': 1 } })
          await db_oem_mtty.collection('bills').update({ taskID: mongodb.ObjectId(taskId), pre: true }, { $set: { pre: false, number: 0 } })
        } else {
          await db_oem_xibao.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 0 } })
          await db_oem_xibao.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'status': 1 } })
          await db_oem_xibao.collection('bills').update({ taskID: mongodb.ObjectId(taskId), pre: true }, { $set: { pre: false, number: 0 } })
        }
              res.send({ status: 201, message: '审核未通过' })
      }
      if (status === 2) {
        let updateTime = new Date()
        if (oem === '微聚合' || oem === null || oem === undefined) {
          await db.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 1, 'checkTime': updateTime } })
        } else if ( oem === '麦田'){
          await db_oem_mtty.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 1, 'checkTime': updateTime } })
        } else {
          await db_oem_xibao.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'checkStatus': 1, 'checkTime': updateTime } })
        }
        res.send({ status: 200, message: '审核通过' })
      }
    })
  } else {
    let sureStatus = db.collection('dspTask').find({ '_id': mongodb.ObjectId(taskId) }).toArray(async (err, rep) => {
      console.log(rep)
      if (!rep[0].status) {
        if (status === 2) {
          if (oem === '微聚合' || oem === null || oem === undefined) {
            await db.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'status': 2, 'sendNum': sendNum } })
            await db.collection('bills').update({ taskID: mongodb.ObjectId(taskId), pre: true }, { $set: { pre: false, number: sendNum * 0.5 } });
          } else if (oem === '麦田'){
            await db_oem_mtty.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'status': 2, 'sendNum': sendNum } })
            await db_oem_mtty.collection('bills').update({ taskID: mongodb.ObjectId(taskId), pre: true }, { $set: { pre: false, number: sendNum * 0.5 } });
          } else {
            await db_oem_xibao.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'status': 2, 'sendNum': sendNum } })
            await db_oem_xibao.collection('bills').update({ taskID: mongodb.ObjectId(taskId), pre: true }, { $set: { pre: false, number: sendNum * 0.5 } });
          }
          
          res.send({ status: 200, message: '审核通过，短信发送中' })
        }
        if (status === 1) {
          
          if (oem === '微聚合' || oem === null || oem === undefined) {
            await db.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'status': 1 } })
            await db.collection('bills').update({ taskID: mongodb.ObjectId(taskId), pre: true }, { $set: { pre: false, number: 0 } });
          } else if (oem === '喜宝'){
            await db_oem_mtty.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'status': 1} })
            await db_oem_mtty.collection('bills').update({ taskID: mongodb.ObjectId(taskId), pre: true }, { $set: { pre: false, number: 0 } });
          } else {
            await db_oem_xibao.collection('dspTask').update({ '_id': mongodb.ObjectId(taskId) }, { $set: { 'status': 1} })
            await db_oem_xibao.collection('bills').update({ taskID: mongodb.ObjectId(taskId), pre: true }, { $set: { pre: false, number: 0 } });
          }
          
          res.send({ status: 201, message: '审核未通过，任务驳回' })
        }
      } else {
        res.send({ status: 200, message: '状态无法更改' })
      }
    })
  }
  let makeSure = db.collection('dspTask').find({ '_id': mongodb.ObjectId(taskId) }).toArray((err, res) => {
    console.log(res)
    if (err) { console.log('错了') }
  })
})

// 账户数据
app.post('/getAccount', async function (req, res) {
  console.log('进入用户控制')
  console.log(req.body)
  let { currentPage, pageSize, choose, sessionID } = req.body

  let accounts = await db.collection('account').find().toArray()
  let dataArr = []
  let emailArr = []

  accounts.forEach(x => {
    let item = {}
    if (x.isDelete) {
      item.isAccountDelete = true
    } else {
      item.isAccountDelete = false
    }
    if (x.isCloseAuto) {
      item.isCloseAuto = true
    } else {
      item.isCloseAuto = false
    }
    item._id = x._id
    item.company = x.company
    item.phone = x.phone
    item.email = x.email
    item.onelevelTag = x.onelevelTag || ''
    item.twolevelTag = x.twolevelTag || ''
    item.tag = { onelvtag: [], twolvtag: [] }
    emailArr.push(x.email)
    if (choose) {
      if (item.email === choose || item.email + '' === choose + '') {
        dataArr.push(item)
      }
    } else {
      dataArr.push(item)
    }
  })

  let dataArrTotal = dataArr.length
  dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  res.send({ status: 200, data: dataArr, dataTotal: dataArrTotal, emailArr: emailArr })
})

// 向公司打标签
app.post('/makeAccountTag', async function(req, res){
  console.log('进入打标签')
  console.log(req.body)
  let {accountID, onelevelTag, twolevelTag} = req.body
  await db.collection('account').update({'_id': mongodb.ObjectId(accountID)}, {$set: {onelevelTag: onelevelTag, twolevelTag: twolevelTag}}, (err, rep) => {
    if (rep) {
      res.send({status: 200, data: '打入标签了'})
    }
  })
})

// 注销接口
app.post('/deleteAccount', async function (req, res) {
  console.log('进入用户控制')
  console.log(req.body)
  let { accountId, status, sessionID} = req.body
  
  if (status === 0 || status === '0') {
    await db.collection('account').update({ '_id': mongodb.ObjectId(accountId) }, { $set: { 'isDelete': true } })
    res.send({ status: 200, data: '用户注销成功' })
  }
  if (status === 1 || status === '1') {
    await db.collection('account').update({ '_id': mongodb.ObjectId(accountId) }, { $set: { 'isDelete': false } })
    res.send({ status: 201, data: '用户恢复成功' })
  }
})

//  自动备案接口
app.post('/closeBtn', async function (req, res) {
  console.log('进入自动备案')
  console.log(req.body)
  let { accountId, status, sessionID} = req.body
  
  if (status === 0 || status === '0') {
    await db.collection('account').update({ '_id': mongodb.ObjectId(accountId) }, { $set: { 'isCloseAuto': true } })
    res.send({ status: 200, data: '自动备案关闭成功' })
  }
  if (status === 1 || status === '1') {
    await db.collection('account').update({ '_id': mongodb.ObjectId(accountId) }, { $set: { 'isCloseAuto': false } })
    res.send({ status: 201, data: '自动备案开启成功' })
  }
})

// 代码位数据
app.post('/getSlot', async function (req, res) {
  console.log('进入获取代码位')
  console.log(req.body)

  let { currentPage, pageSize, choose, sessionID} = req.body

  let company = await db.collection('account').find({}).toArray()

  let slot = await db.collection('slotTemps').find().sort({createdAt: -1}).toArray()

  let dataArr = []
  let emailArr = []

  company.forEach(x => {
    emailArr.push(x.email)
  })
  slot.forEach(x => {
    let item = {}
    item.slotId = x._id
    item.slot = x.durl
    item.slotName = x.slotName
    item.autoRule = x.autoRule
    if (x.relateSlot) {
      item.disable = false
    } else {
      item.disable = true
    }
    item.time = moment(x.createdAt).format('YYYY-MM-DD HH:mm')
    if (x.isSlotDelete) {
      item.isDelete = true
    } else {
      item.isDelete = false
    }
    company.forEach(y => {
      if (x.accountID === y._id || x.accountID + '' === y._id + '') {
        item.company = y.company
        item.email = y.email
      }
    })
    if (choose) {
      if (item.email === choose || item.email + '' === choose + '') {
        dataArr.push(item)
      }
    } else {
      dataArr.push(item)
    }
  })

  let dataTotal = dataArr.length

  dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)

  res.send({ status: 200, data: dataArr, dataTotal: dataTotal, emailArr: emailArr })
})

// 代码位备案策略
app.post('/slotAutoRule', async function (req, res) {
  console.log(req.body)
  let { slotId, autoRule, sessionID} = req.body
  
  await db.collection('slotTemps').update({ '_id': mongodb.ObjectId(slotId) }, { $set: { 'autoRule': autoRule } })
  res.send({ status: 200, message: '备案策略更改成功' })
})

//  代码位开关
app.post('/deleteSlot', async function (req, res) {
  console.log('进入代码位控制')
  console.log(req.body)
  let { slotId, status, sessionID } = req.body
  
  if (status === 0 || status === '0') {
    await db.collection('slotTemps').update({ '_id': mongodb.ObjectId(slotId) }, { $set: { 'isSlotDelete': true } })
    res.send({ status: 200, data: '代码位注销成功' })
  }
  if (status === 1 || status === '1') {
    await db.collection('slotTemps').update({ '_id': mongodb.ObjectId(slotId) }, { $set: { 'isSlotDelete': false } })
    res.send({ status: 201, data: '代码位恢复成功' })
  }
})

// 营销池数据
app.post('/poolData', async function (req, res) {
  console.log('进入营销池数据')
  console.log(req.body)

  let {pageSize, currentPage, onelevelTag, twolevelTag} = req.body
  
  let recognition = await db.collection('marketingPool').find({}).toArray()
  
  let dataArr = []
  
  recognition.forEach(x => {
    let item = {}
    item.unikey = x.unikey
    item.fromEmail = x.fromEmail
    item.fromCompany = x.fromCompany
    item.leadTime = moment(x.leadTime).format('YYYY-MM-DD HH:mm:ss')
    item.onelevelTag = x.onelevelTag || []
    item.twolevelTag = x.twolevelTag || []
    item.tags = x.tags
    item.exportNum = x.exportNum
    item.exportDataArr = x.exportDataArr 
    
    if (onelevelTag && twolevelTag ) {
      item.onelevelTag.forEach(y => {
        if (onelevelTag === y) {
          item.twolevelTag.forEach(z => {
            if (twolevelTag === z) {
              dataArr.push(item)
            }
          })
        }
      })
    } else if (onelevelTag && !twolevelTag) {
      item.onelevelTag.forEach(n => {
        if (onelevelTag === n) {
          dataArr.push(item)
        }
      })
    } else {
      dataArr.push(item)
    }
  })


  let dataTotal = dataArr.length
  dataArr = dataArr.reverse()
  dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  res.send({ status: 200, datas: dataArr, dataTotal: dataTotal})
})

// 导入
app.post('/leadPool', async function (req, res) {

  console.log('进入营销池导入')
  console.log(req.body)
  let { pattern, startTime, endTime, accountID } = req.body

  startTime = moment(startTime).startOf('day').valueOf()
  endTime = moment(endTime).endOf('day').valueOf()
  console.log(startTime)
  console.log(endTime)

  let user = await db.collection('recognition').find({ 'updateTimestamp': { $gt: startTime, $lte: endTime }, pubID: accountID }).toArray()
  console.log(user.length)
  let company = await db.collection('account').find({ '_id': mongodb.ObjectId(accountID) }).toArray()

  let poolUser = await db.collection('marketingPool').find().toArray()

  console.log(poolUser.length)

  let leadTime = moment().toDate()
  let leadFromName = null
  let leadFromEmail = null

  let dataArr = []


  user = _.uniqBy(user, 'unikey')
  
  user.forEach(x => {
    let item = {}
    item.unikey = x.unikey
    item.slotID = x.slotID
    item.pubID = x.pubID
    company.forEach(y => {
      item.onelevelTag = [y.onelevelTag]
      item.twolevelTag = [y.twolevelTag]
      if (y.twolevelTag && y.onelevelTag) {
        item.tags = [y.onelevelTag + '-' + y.twolevelTag]
      } else if (y.onelevelTag){
        item.tags = [y.onelevelTag]
      } else {
        item.tags = []
      }
      if (accountID === y._id + '') {
        leadFromEmail = y.email
        leadFromName = y.company
      }
    })
    dataArr.push(item)
  })

  console.log(dataArr.length)


  let leadArr = []
  let filterArr = []
  let updateArr = []

  if (poolUser.length === 0) {
    leadArr = dataArr
  } else {
    dataArr.forEach(x => {
      poolUser.forEach(y => {
        if (x.unikey === y.unikey) {
          if (x.pubID === y.pubID && x.slotID === y.slotID) {
            filterArr.push(x)
          } else{
            console.log(x.unikey)
            updateArr.push(x)
          }
        } 
      })
    })
    leadArr = _.difference(dataArr, filterArr)
    leadArr = _.difference(leadArr, updateArr)
  }

  leadArr.forEach(x => {
    db.collection('marketingPool').insert({ unikey: x.unikey, onelevelTag: x.onelevelTag, twolevelTag: x.twolevelTag, tags: x.tags, fromEmail: leadFromEmail, fromCompany: leadFromName, leadTime: leadTime })
  })

  updateArr.forEach(x => {
    console.log('更新')
    let onelevelTag = x.onelevelTag[0]
    let twolevelTag = x.twolevelTag[0]
    let tags = x.tags[0]
    db.collection('marketingPool').update({ unikey: x.unikey}, {$push: {onelevelTag: onelevelTag, twolevelTag: twolevelTag, tags: tags}})
  })

  let leadNumber = leadArr.length

  let filterNumber = filterArr.length

  await db.collection('leadTask').insert({ leadNumber: leadNumber, filterNumber: filterNumber, leadTime: leadTime, fromEmail: leadFromEmail, fromCompany: leadFromName })

  res.send({ status: 200, message: '进去了' })
})

// 营销池导入任务
app.post('/getLeadTask', async function (req, res) {

  let leadTask = await db.collection('leadTask').find().toArray()

  let dataArr = []

  leadTask.forEach(x => {
    let item = {}
    item.taskID = x._id
    item.leadNumber = x.leadNumber
    item.filterNumber = x.filterNumber
    item.fromEmail = x.fromEmail
    item.fromCompany = x.fromCompany
    item.leadTime = moment(x.leadTime).format('YYYY-MM-DD HH:mm:SS')
    dataArr.push(item)
  })
  dataArr = dataArr.reverse()
  res.send({ status: 200, datas: dataArr })
})

// 获取筛选
app.post('/getEmail', async function (req, res) {
  console.log(req.body)
  let { accountID } = req.body

  let company = await db.collection('account').find().toArray()

  let slot = []

  if (accountID) {
    slot = await db.collection('slotTemps').find({ accountID: mongodb.ObjectId(accountID) }).toArray()
  } else {
    slot = await db.collection('slotTemps').find().toArray()
  }


  let emailArr = []

  let slotArr = []

  company.forEach(x => {
    let item = {}
    item.email = x.email
    item.accountID = x._id
    emailArr.push(item)
  })

  slot.forEach(x => {
    let item = {}
    item.slotName = x.slotName
    item.slotID = x._id
    slotArr.push(item)
  })
  res.send({ status: 200, emailArr: emailArr, slotArr: slotArr })
})

// 导出
app.post('/exprot', async function (req, res) {
  console.log(req.body)
  let { selectUnikeyArr, exportDataArr, selectUnikeyNumber } = req.body

  let exportTime = moment().valueOf()

  let createRecogNum = 0

  let allCount = 0

  let errCount = 0

  selectUnikeyArr.forEach(async x => {

    await db.collection('marketingPool').update({ unikey: x }, { $addToSet: { exportDataArr: { $each: exportDataArr } }, $inc: { exportNum: 1 } })

    exportDataArr.forEach(async y => {
      
      await db.collection('recognition').find({ unikey: x, pubID: y.accountID, slotID: y.slotID }).toArray(async (err, response) => {
        if (err) { count(err) }
        if (response === [] || response.length === 0) {
          let date = moment(exportTime).format('YYYYMMDD')
          await db.collection('recognition').insert({ unikey: x, pubID: y.accountID, slotID: y.slotID, updateTimestamp: exportTime, auditStatus: 0, score: 3, scoreTimestamp: exportTime, fromPool: true, date: date})
          count()
        } else {
          count(true)
        }
      })
    })
  })
  function count(err) {
    allCount++
    if (err) {
      errCount++
    } else {
      createRecogNum++
    }
    if (allCount === selectUnikeyArr.length * exportDataArr.length) {
      console.log('存入任务表中')
      console.log(errCount, createRecogNum)
      db.collection('exportTask').insert({ 'exportUnikeyNumber': selectUnikeyNumber, createRecogNum: createRecogNum, exportTime: exportTime, exportDataArr: exportDataArr })
      res.send({ status: 200, message: '导出了' })
    }
  }
})

// 导出任务列表
app.post('/getExportTask', async function (req, res) {
  console.log('导出任务列表')
  console.log(req.body)

  let exportTask = await db.collection('exportTask').find().toArray()

  let dataArr = []
  exportTask.forEach(x => {
    let item = {}
    item.taskID = x._id
    item.exportUnikeyNumber = x.exportUnikeyNumber
    item.createRecogNum = x.createRecogNum
    item.exportTime = moment(x.exportTime).format('YYYY-MM-DD HH:mm:SS')
    item.exportDataArr = x.exportDataArr
    dataArr.push(item)
  })
  dataArr = dataArr.reverse()
  res.send({ status: 200, datas: dataArr })
})


// 审核Url
app.post('/getUrlData', async function (req, res) {
  console.log(req.body)
  
  let {startTime, endTime, currentPage, pageSize, status} = req.body
  

  startTime = moment(startTime).startOf('day').toDate()
  endTime = moment(endTime).endOf('day').toDate()

  console.log(startTime)
  console.log(endTime)


  let url = await db.collection('urlTemps').find({createdAt: {$gt: startTime, $lte: endTime}}).toArray()

  let companyName = await db.collection('account').find({}).toArray()

  let dataArr = [] 

  url.forEach(x => {
    let item = {}
    item.slotId = x._id
    item.slot = x.durl
    item.slotName = x.slotName
    item.time = moment(x.createdAt).format('YYYY-MM-DD HH:mm:SS')
    switch(x.status) {
      case 0: item.status = '未审核'; break;
      case 1: item.status = '已拒绝'; break;
      case 2: item.status = '已通过'; break;
      default: item.status = '未审核'; 
    }
    companyName.forEach(y => {
      if (x.accountID === y._id || x.accountID + '' === y._id + '') {
        item.company = y.company
        item.email = y.email
      }
    })
    if (status === item.status) {
      dataArr.push(item)
    }
    if (status === '全部状态') {
      dataArr.push(item)
    }
  })
  console.log(dataArr)
  let totalNum = dataArr.length

  dataArr = dataArr.slice((currentPage - 1) * pageSize, pageSize * currentPage)
  if (totalNum > 1000) {
    dataArr = dataArr.slice(0, 1000)
  }  
  res.send({status: 200, total: totalNum, datas: dataArr})
})


app.post('/checkUrl', async function (req, res) {
  console.log(req.body)
  let {slotId, status} = req.body
  
  if (status === 1) {
    await db.collection('urlTemps').update({_id: mongodb.ObjectId(slotId), status: 0}, {$set: {status: 1}}, {upsert: true}, (err, rep) => {
      if (err) { 
        console.log(err) 
        res.send({status: 700, message: err})
        return
      } else {
        res.send({status: 200, message: 'Url拒绝成功'})
      }
    })
  }

  if (status === 2) {
    await db.collection('urlTemps').update({_id: mongodb.ObjectId(slotId), status: 0}, {$set: {status: 2}}, {upsert: true}, (err, rep) => {
      if (err) { 
        console.log(err) 
        res.send({status: 700, message: err})
        return
      } else {
        res.send({status: 200, message: 'Url审核通过'})
      }
    })
  }

  if (status === 8) {
    await db.collection('urlTemps').update({_id: mongodb.ObjectId(slotId)}, {$set: {status: 0}}, {upsert: true}, (err, rep) => {
      if (err) { 
        console.log(err) 
        res.send({status: 700, message: err})
        return
      } else {
        res.send({status: 200, message: '重置完成'})
      }
    })
  }
}) 


app.post('/entry', function(req, res) {
   console.log(req.body)
  let {billID} = req.body
  let url = 'http://remarketing-job-yh.yoo.yunpro.cn/fileStatusDSP?billID=' + billID
  request(url, (err, response) => {
    if (err) {
      return console.log(err)
    }
    console.log(response.statusCode, response.message)
    if (response.statusCode === 200) {
      res.send({status: 200, datas: response.message})
    } 
    if (response.statusCode === 204) {
      res.send({status: 204, message: '订单数据未找到(运营商未返回任务记录)'})
      // res.send({status: 200, datas: {
      //   billCheck: {
      //     result : "通过", // 结果(下同）
      //     at : 1531979761733.0 // 执行时间戳(下同）
      //   },
      //   fileCheck: {
      //     result : "通过",
      //     at : 1531979761733.0
      //   },
      //   countCheck: {
      //     result : "通过",
      //     at : 1531979761733.0,
      //     now: 500, // 当前数量
      //     expect: 500 // 期待数量
      //   },
      //   tagCheck: {
      //     result : "通过",
      //     at : 1531979761733.0,
      //     lose: 0, // 缺失量
      //     total: 500 // 期待数量
      //   },
      //   randomCall: {
      //     result : "通过",
      //     at : 1531979761733.0
      //   }
      // }})
    }
  })
})


app.post('/entryIn', function(req, res) {
   console.log(req.body)
  let {billID} = req.body
  let url = 'http://remarketing-job-yh.yoo.yunpro.cn/fileReaderDSP?billID=' + billID
  request(url, (err, response) => {
    if (err) {
      return console.log(err)
    }
    console.log(response.statusCode, response.message)
    if (response.statusCode === 200) {
      res.send({status: 200, datas: response.message})
    } 
    if (response.statusCode === 204) {
      res.send({status: 204, message: '订单数据未找到'})
    }
  })
})


module.exports = app
