const type = {
  GET_DATA: 'GET_DATA',
  SEND: 'SEND',
  GET_EMAIL: 'GET_EMAIL'
}

const state = {
  datas: [],
  allDatas: [],
  emails: []
}

const getters = {
  getDatas () {
    return state.datas
  },
  getAccount () {
    return state.emails
  }
}

const mutations = {
  [type.GET_DATA] (state, data) {
    state.datas = data
  },
  [type.GET_EMAIL] (state, data) {
    state.emails = data
  }
}


const actions = {
  [type.GET_DATA] ({commit}, {url, choose, callback}) {
    console.log(url, choose)
    fetch(url, {
      method: 'POST',
      headers: {'Content-Type': 'application/json;charset=UTF-8'},
      body: JSON.stringify(choose)
    }).then(res => { 
      return res.json() 
    }).then(data => {
      commit(type.GET_DATA, data)
      callback(null, data)
    }).catch(err => {
      callback(err, null)
    }) 
  },
  [type.SEND] ({commit}, {url, choose, callback}) {
    console.log(url, choose)
    fetch(url, {
      method: 'POST',
      headers: {'Content-Type': 'application/json;charset=UTF-8'},
      body: JSON.stringify(choose)
    }).then(res => {
      return res.json()
    }).then(data => {
      console.log(data)
      
      if (data.status === 0) {
        this.$message({
          message: data.message,
          type: 'error'
        })
      }
      if (data.status === 1) {
        this.$message({
          message: data.message,
          type: 'success'
        })
      }

      callback(null, data)
    }).catch(err => {
      this.message({
        message: err,
        type: 'error'
      })
      callback(err, null)
    })
  },
  [type.GET_EMAIL] ({commit}) {
    fetch('/api/getEmail', {
      method: 'POST',
      headers: {'Content-Type': 'application/json;charset=UTF-8'},
      body: null
    }).then(res => {
      return res.json()
    }).then(data => {
      console.log(data)
      commit(type.GET_EMAIL, data.emailArr)
    }).catch(err => {
      return console.log(err)
    })
  } 
}

export default {
  state,
  getters,
  mutations,
  actions
}
