// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import App from './App'
import router from './router'
import ElemetnUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import store from './store/index'

Vue.config.productionTip = false
Vue.use(ElemetnUI)
/* eslint-disable no-new */


router.beforeEach((to, from, next) => {
  let sureSession = sessionStorage.getItem('sessionID')
  console.log(sureSession)
  if (to.matched.some(record => record.meta.requiresId)) {
    if (!sureSession) {
      next({path: '/login'})
      console.log(1)
    } else {
      next()
    }
    if (sureSession) {
      next()
    } else {
      next({path: '/login'})
      console.log(2)
    }
  } else {
    next()
  }
})


new Vue({
  el: '#app',
  store,
  router,
  components: {App},
  template: '<App/>'
})
