const mongodb = require('mongodb')
const mongoClient = mongodb.MongoClient
const app = require('express').Router()
const _ = require('lodash')
const axios = require('axios')
const moment = require('moment')
var db = {}

const dbpath = 'mongodb://localhost:27017/remarketing'

mongoClient.connect(dbpath, function (err, res) {
  if (err) return console.log(err)
  db = res.db('remarketing')
  db.collection('msgTemps').find({}).toArray((err, r) => {
    console.log('数据库已经连接')
  })
})

app.post('/dataList', async function (req, res) {
  console.log('进入了dataList')
  let body = req.body
  let { startTime, endTime, total, pageSize, currentPage } = req.body
  console.log(body)
  console.log(startTime, endTime)
  let dateQs = getTimeRange({start: startTime, end: endTime, type: 'direct', key: 'date'})
  console.log(dateQs)

  let results = await db.collection('dailyStats').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        pv: {$sum: '$pv'},
        uid: {$sum: '$uid'}
      }
    }]).sort({'date': -1}).toArray()
  // console.log(results)

  let touchCount = await db.collection('recognition').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        touchCount: {$sum: 1}
      }
    }]).sort({'date': -1}).toArray()
  // console.log(touchCount)



  let msgTask = await db.collection('task').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$accountID',
        msgCount: {$sum: 1}
      }
    }]).sort({'date': -1}).toArray()

  let callTask = await db.collection('callTask').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: '$pubID',
        callCount: {$sum: 1}
      }
    }]).sort({'date': -1}).toArray()
  console.log(callTask)

  let companyName = await db.collection('account').aggregate([
    {
      $project: {
        _id: '$_id',
        company: '$company',
        email: '$email'
      }
    }]).sort({'date': -1}).toArray()
  console.log(companyName)

  let getCount = await db.collection('recognition').aggregate([
    {
      $match: _.merge(dateQs, {auditStatus: {$eq: 2}})
    },
    {
      $group: {
        _id: '$pubID',
        getCount: {$sum: 1}
      }
    }]).sort({'date': -1}).toArray()

  let data = _.merge(results, companyName, touchCount, getCount, msgTask, callTask)

  let datas = data.slice((currentPage - 1) * pageSize, currentPage * pageSize)

  datas = _.enhance(datas, {time: endTime})

  res.send({status: 200, total: data.length, time: startTime, data: datas})
})

app.post('/consume', async function (req, res) {
  console.log('进入了consume')

  let { startTime, endTime, total, pageSize, currentPage } = req.body

  let dateQs = getTimeRange({start: startTime, end: endTime, type: 'direct', key: 'date'})


  let counsume = await db.collection('bills').aggregate([
    {
      $match: dateQs
    },
    {
      $group: {
        _id: {accountID: '$accountID', pre: '$pre'},
        number: {$sum: '$number'}
      }
    }]).toArray()

  let companyName = await db.collection('account').aggregate([
    {
      $project: {
        _id: '$_id',
        company: '$company',
        email: '$email'
      }
    }]).sort({'date': -1}).toArray()

  let data = [];
  let preData = [];
  for (let i = 0; i < counsume.length; i++){
    if (counsume[i]._id.pre === true){
      data.push({_id: counsume[i]._id.accountID, number: counsume[i].number})
    } else {
      preData.push({_id: counsume[i]._id.accountID, preNumber: counsume[i].number})
    }
  }

  let consumeTotalNumber = 0
  for (let i = 0; i < data.length; i++) {
    consumeTotalNumber += data[i].number
  }
  console.log(consumeTotalNumber)

  let preTotalNumber = 0
  for (let i = 0; i < data.length; i++) {
    preTotalNumber += data[i].number
  }
  console.log(preTotalNumber)
  let datas = _.merge(data, preData, companyName)

  datas = datas.slice((currentPage - 1) * pageSize, currentPage * pageSize)

  datas = _.enhance(datas, {time: endTime})


  res.send({status: 200, consumeTotalNumber: consumeTotalNumber, preTotalNumber: preTotalNumber, total: data.length, data: datas})
})

app.post('/finance', async function (req, res) {
  console.log('进入了finance')

  console.log(req.body)

  let { startTime, endTime, total, pageSize, currentPage } = req.body

  startTime = moment(startTime).toDate()
  endTime = moment(endTime).toDate()
  console.log(startTime)
  console.log(endTime)

  let finance = await db.collection('recharge').aggregate([
    {
      $match: {createdAt: {$gt: startTime, $lte: endTime}}
    },
    {
      $group: {
        _id: '$accountID',
        number: {$sum: '$number'}
      }
    }]).toArray()

  console.log(finance)
  let companyName = await db.collection('account').aggregate([
    {
      $project: {
        _id: '$_id',
        company: '$company',
        email: '$email'
      }
    }]).sort({'date': -1}).toArray()
  let datas = _.merge(finance, companyName)

  console.log(datas)

  startTime = moment(startTime).format('YYYY-MM-DD')
  endTime = moment(endTime).format('YYYY-MM-DD')

  let financeNumber = 0

  console.log(financeNumber)
  for (let i = 0; i < datas.length; i++) {
    if (datas[i].number) {
      financeNumber += datas[i].number
    }
  }
  financeNumber = Math.floor(financeNumber)

  datas = _.enhance(datas, {time: endTime})

  datas = datas.slice((currentPage - 1) * pageSize, currentPage * pageSize)

  res.send({status: 200, total: datas.length, financeNumber: financeNumber, data: datas})
})


_.enhance = function (list, source) {
  return _.map(list, function (element) {
    return _.extend({}, element, source)
  })
}

function getTimeRange ({start, end, type, key}) {
  if (/^[0-9]{8}$/.test(start) && /^[0-9]{8}$/.test(end)) {
    if (type === 'millisecond') {
      return {
        [key]: {
          '$gt': parseInt(moment(start, 'YYYYMMDD').startOf('day').format('x')),
          '$lte': parseInt(moment(end, 'YYYYMMDD').endOf('day').format('x'))
        }
      };
    } else if (type === 'direct') {
      return {[key]: {'$gte': start, '$lte': end}};
    } else {
      return {
        [key]: {
          '$gt': moment(start, 'YYYYMMDD').startOf('day').toDate(),
          '$lte': moment(end, 'YYYYMMDD').endOf('day').toDate()
        }
      };
    }
  } else {
    if (type === 'millisecond') {
      return {
        [key]: {
          '$gt': parseInt(moment().add(-7, 'days').startOf('day').format('x')),
          '$lte': parseInt(moment().endOf('day').format('x'))
        }
      };
    } else if (type === 'direct') {
      console.log(start)
      console.log(end)
      return {
        [key]: {
          '$gt': moment(start).format('YYYYMMDD'),
          '$lte': moment(end).format('YYYYMMDD')
        }
      };
    } else {
      return {[key]: {'$gt': moment().add(-7, 'days').startOf('day').toDate(), '$lte': moment().endOf('day').toDate()}};
    }
  }
}

module.exports = app
