import React, { useState, useEffect } from 'react'
import { Layout, Flex, Card, Button, Form, Input } from 'antd'
import { UploadOutlined } from '@ant-design/icons'
import UploadVideo from './components/uploadVideo'
import $eventbus from '../../utils/EventBus.js'
import { useNavigate } from 'react-router-dom'
import axios from 'axios'

const { Header, Footer, Content } = Layout

const headerStyle = {
  color: '#fff',
  height: 64,
  paddingInline: 48,
  lineHeight: '64px',
  backgroundColor: '#4096ff'
}
const contentStyle = {
  minHeight: 120,
  lineHeight: '120px',
  color: '#fff',
  backgroundColor: '#0958d9',
  display: 'flex',
  flexDirection: 'row',
  justifyContent: 'space-around',
  flexWrap: 'wrap',
  padding: 25,
  gap: 25
}
const footerStyle = {
  color: '#fff',
  backgroundColor: '#4096ff'
}
const layoutStyle = {
  borderRadius: 8,
  overflow: 'hidden',
  width: 'calc(100% - 8px)',
  maxWidth: 'calc(100% - 8px)',
  minHeight: '100vh'
}

const Upload = () => {
  const navigate = useNavigate()
  const [loading, setLoading] = useState(false)
  const [folds, setFolds] = useState([])
  const [form] = Form.useForm()

  const submitTask = async () => {
    let values = ''
    try {
      values = await form.validateFields()
      console.log('Success:', values)
    } catch (errorInfo) {
      console.log('Failed:', errorInfo)
      return
    }
    if (!values.productDesc) {
      alert('Please input the description of your product')
      return
    }

    let filmFold = folds.find((fold) => fold.group === 0)
    let shotFold = folds.find((fold) => fold.group === 1)
    if (!filmFold) {
      alert('Please upload excellent videos')
      return
    }
    if (!shotFold) {
      alert('Please upload project footage')
      return
    }

    let reqData = {
      filmDirName: filmFold.name,
      shotDirName: shotFold.name,
      productDesc: values.productDesc,
      count: 5
    }
    console.log(reqData)
    setLoading(true)

    const res = axios.post('http://10.20.1.10:3100/2403/learnvideo/start', reqData)

    let timer = setTimeout(() => {
      clearTimeout(timer)
      setLoading(false)
      navigate('/preview', { state: { reqData } })
    }, 2000)
  }

  useEffect(() => {
    const recvFoldData = (fold) => {
      console.log('======================')
      setFolds((prevFolds) => {
        const newFolds = [...prevFolds]
        newFolds.push(fold)
        return newFolds
      })
    }
    $eventbus.on('upload_fold_name', recvFoldData)
    return () => {
      $eventbus.off('upload_fold_name', recvFoldData)
    }
  }, [])

  return (
    <Flex gap="middle" wrap="wrap">
      <Layout style={layoutStyle}>
        <Header style={headerStyle}>TapVideo</Header>
        <Content style={contentStyle}>
          <UploadVideo title="Upload excellent videos：" group={0} />
          <UploadVideo title="Upload project shots：" group={1} />
          {/* <Card
            bordered={false}
            style={{
              display: 'flex',
              flexDirection: 'column',
              justifyContent: 'center',
              alignItems: 'center',
              flexBasis: 'max(calc(95%), min(400px, calc(100%)))',
              marginTop: 25
            }}> */}
            {/* <Button type="primary" size="large" icon={<UploadOutlined />} loading={loading} onClick={() => submitTask()}>
              点击生成视频
            </Button> */}
            <Form
              // inputFontSizeLG
              form={form}
              name="wrap"
              labelCol={{
                flex: '110px'
              }}
              labelAlign="left"
              labelWrap
              wrapperCol={{
                flex: 1
              }}
              colon={false}
              style={{
                display: 'flex',
                flexDirection: 'column',
                
                maxWidth: 1600,
                width: '50vw',
                flexBasis: 'max(calc(95%), min(400px, calc(100%)))',
                backgroundColor: '#fff',
                borderRadius: 10,
                padding: 20
              }}>
              <Form.Item label="DESCRIPTION：" name="productDesc" inputFontSize={20}>
                <Input placeholder="Please input the description of your product" />
              </Form.Item>

              <Form.Item label=" ">
                <Button type="primary" size="large" htmlType="submit" loading={loading} onClick={() => submitTask()} style={{
                }}>
                Click to generate
                </Button>
              </Form.Item>
            </Form>
          {/* </Card> */}
        </Content>
        <Footer style={footerStyle}>©Goyoo</Footer>
      </Layout>
    </Flex>
  )
}

export default Upload
