import React from 'react'
import { InboxOutlined } from '@ant-design/icons'
import { message, Upload, Card } from 'antd'
import $eventbus from '../../../../utils/EventBus.js'

const { Dragger } = Upload

const UploadVideo = (props) => {
  let lock = false
  const opts = {
    name: 'file',
    accept: '.mp4',
    multiple: false,
    directory: true,
    action: 'http://10.20.1.10:3100/2403/learnvideo/upload',
    beforeUpload(file) {
      if (file.webkitRelativePath.split('/').length != 2) {
        console.log('---', file.webkitRelativePath)
        return Upload.LIST_IGNORE
      }
      if (!lock) {
        $eventbus.emit('upload_fold_name', {
          group: props.group,
          name: file.webkitRelativePath.split('/')[0]
        })
        lock = true
      }
    },
    customRequest(config) {
      let rand = Math.random() * 1500
      let timer = setTimeout(() => {
        clearTimeout(timer)
        config.onSuccess()
      }, rand)
    },
    onChange(info) {
      const { status } = info.file
      if (status !== 'uploading') {
        // console.log(info.file, info.fileList)
      }
      if (status === 'done') {
        message.success(`${info.file.name} file uploaded successfully.`)
      } else if (status === 'error') {
        message.error(`${info.file.name} file upload failed.`)
      }
    },
    onDrop(e) {
      // console.log('Dropped files', e.dataTransfer.files)
    }
  }

  return (
    <Card
      title={props.title}
      bordered={false}
      style={{
        flexBasis: 'max(400px, calc(44%))',
        marginTop: 25
      }}>
      <Dragger {...opts}>
        <p className="ant-upload-drag-icon">
          <InboxOutlined />
        </p>
        <p className="ant-upload-text">Click or drag the folder to this area for uploading</p>
      </Dragger>
    </Card>
  )
}

export default UploadVideo
