import React, { useState, useEffect } from 'react'
import { Layout, Flex, Card, Button } from 'antd'
import { UploadOutlined } from '@ant-design/icons'
import UploadVideo from './components/uploadVideo'
import $eventbus from '../../utils/EventBus.js'
import { useNavigate } from 'react-router-dom'

const { Header, Footer, Content } = Layout

const headerStyle = {
  color: '#fff',
  height: 64,
  paddingInline: 48,
  lineHeight: '64px',
  backgroundColor: '#4096ff'
}
const contentStyle = {
  minHeight: 120,
  lineHeight: '120px',
  color: '#fff',
  backgroundColor: '#0958d9',
  display: 'flex',
  flexDirection: 'row',
  justifyContent: 'space-around',
  flexWrap: 'wrap',
  padding: 25,
  gap: 25
}
const footerStyle = {
  color: '#fff',
  backgroundColor: '#4096ff'
}
const layoutStyle = {
  borderRadius: 8,
  overflow: 'hidden',
  width: 'calc(100% - 8px)',
  maxWidth: 'calc(100% - 8px)'
}

const Upload = () => {
  const navigate = useNavigate()
  const [loading, setLoading] = useState(false)
  const [folds, setFolds] = useState([])
  const fetchData = async () => {
    setLoading(true)
    // const res = await fetch('http://10.20.1.10:port/upload', {
    //   method: "POST",
    //   mode: "cors",
    //   body: JSON.stringify(folds)
    // })
    // if(res.status == 200) {
    //   setLoading(false)
    //   const videos = res.body
    //   navigate('/preview', { state: { videos } })
    // } else {
    //   console.error('res.status:', res.status)
    // }

    setTimeout(() => {
      const videos = [
        {
          src: '/test.mp4'
        },
        {
          src: '/test.mp4'
        },
        {
          src: '/test.mp4'
        }
      ]
      setLoading(false)
      navigate('/preview', { state: { videos } })
    }, 3000)
  }

  useEffect(() => {
    const recvFoldData = (fold) => {
      console.log('======================')
      setFolds((prevFolds) => {
        const newFolds = [...prevFolds]
        newFolds.push(fold)
        return newFolds
      })
    }
    $eventbus.on('upload_fold_name', recvFoldData)
    return () => {
      $eventbus.off('upload_fold_name', recvFoldData)
    }
  }, [])

  return (
    <Flex gap="middle" wrap="wrap">
      <Layout style={layoutStyle}>
        <Header style={headerStyle}>上传数据</Header>
        <Content style={contentStyle}>
          <UploadVideo title="上传第一组视频：" group={0} />
          <UploadVideo title="上传第二组视频：" group={1} />
          <Card
            bordered={false}
            style={{
              display: 'flex',
              justifyContent: 'space-around',
              flexBasis: 'max(calc(95%), min(400px, calc(100%)))',
              marginTop: 25
            }}>
            <Button type="primary" size="large" icon={<UploadOutlined />} loading={loading} onClick={() => fetchData()}>
              上传处理视频
            </Button>
          </Card>
        </Content>
        <Footer style={footerStyle}>Footer</Footer>
      </Layout>
    </Flex>
  )
}

export default Upload
