import React from 'react'
import { InboxOutlined } from '@ant-design/icons'
import { message, Upload, Card } from 'antd'
import $eventbus from '../../../../utils/EventBus.js'

const { Dragger } = Upload

const UploadVideo = (props) => {
  let lock = false
  const opts = {
    name: 'file',
    multiple: false,
    directory: true,
    action: 'https://run.mocky.io/v3/435e224c-44fb-4773-9faf-380c5e6a2188',
    beforeUpload(file) {
      console.log('++++++++++')
      console.log(file)
      if (!lock) {
        $eventbus.emit('upload_fold_name', {
          group: props.group,
          name: file.webkitRelativePath.split('/')[0]
        })
        lock = true
      }
    },
    onChange(info) {
      const { status } = info.file
      if (status !== 'uploading') {
        console.log(info.file, info.fileList)
      }
      if (status === 'done') {
        message.success(`${info.file.name} file uploaded successfully.`)
      } else if (status === 'error') {
        message.error(`${info.file.name} file upload failed.`)
      }
    },
    onDrop(e) {
      console.log('Dropped files', e.dataTransfer.files)
    }
  }

  return (
    <Card
      title={props.title}
      bordered={false}
      style={{
        flexBasis: 'max(400px, calc(44%))',
        marginTop: 25
      }}>
      <Dragger {...opts}>
        <p className="ant-upload-drag-icon">
          <InboxOutlined />
        </p>
        <p className="ant-upload-text">单击或拖动文件夹到此区域进行上传</p>
        <p className="ant-upload-hint">支持单次或批量上传。</p>
      </Dragger>
    </Card>
  )
}

export default UploadVideo
