import React, { useEffect, useState } from 'react'
import { Layout, Flex } from 'antd'
import VideoBox from './components/videoBox'
import { useLocation } from 'react-router-dom'

const { Header, Footer, Content } = Layout

const headerStyle = {
  color: '#fff',
  height: 64,
  paddingInline: 48,
  lineHeight: '64px',
  backgroundColor: '#4096ff'
}
const contentStyle = {
  minHeight: 120,
  lineHeight: '120px',
  color: '#fff',
  backgroundColor: '#0958d9',
  display: 'flex',
  flexDirection: 'row',
  flexWrap: 'wrap',
  justifyContent: 'flex-start',
  alignItems: 'flex-start',
  alignContent: 'flex-start',
  padding: 25,
  gap: 25
}
const footerStyle = {
  color: '#fff',
  backgroundColor: '#4096ff'
}
const layoutStyle = {
  borderRadius: 8,
  overflow: 'hidden',
  width: 'calc(100% - 8px)',
  maxWidth: 'calc(100% - 8px)',
  minHeight: '100vh'
}

const VideoList = () => {
  const { state } = useLocation()
  const [videos, setVideos] = useState([])

  useEffect(() => {
    console.log('state is:', state)
    if (state.videos.length) {
      setVideos(() => state.videos.map((video, index) => <VideoBox src={video.src} key={index} />))
    }
  }, [])

  return <>{videos}</>
}

const Preview = () => {
  return (
    <Flex gap="middle" wrap="wrap">
      <Layout style={layoutStyle}>
        <Header style={headerStyle}>预览数据</Header>
        <Content style={contentStyle}>
          <VideoList />
        </Content>
        <Footer style={footerStyle}>Footer</Footer>
      </Layout>
    </Flex>
  )
}

export default Preview
