import { Spin } from 'antd'
import { LoadingOutlined } from '@ant-design/icons'

const VideoBox = (props) => {
  let spin = (
    <Spin
      delay={1000}
      spinning={false}
      indicator={
        <LoadingOutlined
          style={{
            fontSize: 64
          }}
          spin
        />
      }
    />
  )
  return (
    <div
      style={{
        width: 200,
        height: 330,
        display: 'flex',
        justifyContent: 'center',
        alignItems: 'center',
        backgroundColor: '#E4E4E4',
        padding: 0,
        margin: 0,
        borderRadius: 10,
        cursor: 'pointer',
        overflow: 'hidden'
      }}>
      <video controls width="100%">
        <source src={props.src} type="video/mp4" />
      </video>
    </div>
  )
}

export default VideoBox
