import React, { useEffect, useState } from 'react'
import { Layout, Flex, message } from 'antd'
import VideoBox from './components/videoBox'
import { useLocation } from 'react-router-dom'
import axios from 'axios'

const { Header, Footer, Content } = Layout

const headerStyle = {
  color: '#fff',
  height: 64,
  paddingInline: 48,
  lineHeight: '64px',
  backgroundColor: '#4096ff'
}
const contentStyle = {
  minHeight: 120,
  backgroundColor: '#0958d9',
  display: 'flex',
  flexDirection: 'row',
  flexWrap: 'wrap',
  justifyContent: 'flex-start',
  alignItems: 'flex-start',
  alignContent: 'flex-start',
  padding: 25,
  gap: 25
}
const footerStyle = {
  color: '#fff',
  backgroundColor: '#4096ff'
}
const layoutStyle = {
  borderRadius: 8,
  overflow: 'hidden',
  width: 'calc(100% - 8px)',
  maxWidth: 'calc(100% - 8px)',
  minHeight: '100vh'
}

const VideoList = () => {
  const { state } = useLocation()
  const [Videos, setVideos] = useState([])

  //Call the backend interface to obtain the latest video results
  // const refreshVideo = async () => {
  //   let res = null
  //   try {
  //     res = await axios.get(`http://10.20.1.10:3100/2403/learnvideo/check?shotDirName=${state.reqData.shotDirName}`)
  //   } catch (err) {
  //     message.error('Connect server failed')
  //     console.error(err)
  //   }

  //   if (res.data.code != 200) {
  //     console.log(res.data)
  //     message.error(`request server failed: ${res.data.code}`)
  //   }
  //   //Always refresh display list
  //   if (res.data.data.length) {
  //     let _Videos = res.data.data.map((video, index) => {
  //       let videoData = {
  //         url: video.url,
  //         targetAudience: video.data.targetAudience,
  //         painPoint: video.data.painPoint
  //       }
  //       return <VideoBox videoData={videoData} key={index} />
  //     })
  //     setVideos(_Videos)
  //   }
  //   let timer = setTimeout(() => {
  //     clearTimeout(timer)
  //     refreshVideo()
  //   }, 4000)
  // }

  useEffect(() => {
    console.log('state_is:', state)

    // 模拟请求和渲染过程
    let res = {}
    res.data = {
      code: 200,
      data: [
        {
          url: '/test.mp4',
          data: {
            targetAudience: '1忙碌的上班族和年轻家庭主妇...',
            painPoint: '1工作繁忙，没时间去市场挑选新鲜海鲜...'
          }
        },
        {
          url: '/test.mp4',
          data: {
            targetAudience: '2忙碌的上班族和年轻家庭主妇...',
            painPoint: '2工作繁忙，没时间去市场挑选新鲜海鲜...'
          }
        },
        {
          url: '/test.mp4',
          data: {
            targetAudience: '3忙碌的上班族和年轻家庭主妇...',
            painPoint: '3工作繁忙，没时间去市场挑选新鲜海鲜...'
          }
        }
      ]
    }
    const refreshVideo = () => {
      setTimeout(() => {
        if (res.data.code == 200) {
          let _Videos = res.data.data.map((video, index) => {
            let videoData = {
              url: video.url,
              targetAudience: video.data.targetAudience,
              painPoint: video.data.painPoint
            }
            return <VideoBox videoData={videoData} key={index} />
          })
          setVideos(_Videos)
          res.data.data.push({
            url: '/test.mp4',
            data: {
              targetAudience: '3忙碌的上班族和年轻家庭主妇...',
              painPoint: '3工作繁忙，没时间去市场挑选新鲜海鲜...'
            }
          })
          refreshVideo()
        }
      }, 3000)
    }


    refreshVideo()
  }, [])
  return <>{Videos}</>
}

const Preview = () => {
  return (
    <Flex gap="middle" wrap="wrap">
      <Layout style={layoutStyle}>
        <Header style={headerStyle}>TapVideo</Header>
        <Content style={contentStyle}>
          <VideoList />
        </Content>
        <Footer style={footerStyle}>©Goyoo</Footer>
      </Layout>
    </Flex>
  )
}

export default Preview
