import { Spin } from 'antd'
import { LoadingOutlined } from '@ant-design/icons'

const VideoBox = (props) => {
  let spin = (
    <Spin
      delay={1000}
      spinning={false}
      indicator={
        <LoadingOutlined
          style={{
            fontSize: 64
          }}
          spin
        />
      }
    />
  )
  return (
    <div
      style={{
        width: 440,
        height: 330,
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'space-between',
        backgroundColor: '#E4E4E4',
        padding: 0,
        margin: 0,
        borderRadius: 10,
        overflow: 'hidden'
      }}>
      <div
        style={{
          width: '42%',
          height: '100%',
          overflow: 'hidden',
          backgroundColor: 'orange'
        }}>
        <video
          controls
          height="100%"
          style={{
            cursor: 'pointer',
            overflow: 'hidden'
          }}>
          <source src={props.videoData.url} type="video/mp4" />
        </video>
      </div>
      <div
        style={{
          flex: 1,
          width: '58%',
          height: '100%',
          padding: 10,
          backgroundColor: '#fff',
          display: 'flex',
          flexDirection: 'column'
        }}>
        <div
          style={{
            flex: 1,
            height: '50%',
            marginBottom: 16
            // backgroundColor: 'skyblue'
          }}>
          <div
            style={{
              height: '18%',
              fontSize: 18,
              fontWeight: 'bold',
              borderBottom: '1px solid #000'
            }}>
            Target user group：
          </div>
          <div
            style={{
              height: '82%',
              fontSize: 15,
              overflowY: 'auto',
              lineHeight: '24px'
            }}>
            {props.videoData.targetAudience}
          </div>
        </div>
        <div
          style={{
            flex: 1,
            height: '50%'
          }}>
          <div
            style={{
              width: '100%',
              height: '18%',
              fontSize: 18,
              fontWeight: 'bold',
              borderBottom: '1px solid #000'
            }}>
            Pain points for users：
          </div>
          <div
            style={{
              width: '100%',
              height: '100%',
              fontSize: 15,
              overflowY: 'auto'
            }}>
            {props.videoData.painPoint}
          </div>
        </div>
      </div>
    </div>
  )
}

export default VideoBox
