import request from 'request'
import sha1 from 'sha1'

const appid = 'wx66e59f0e402601f3';
const secret = '184897070ca93a0e563cb6b79962a98c';
const url = 'http://hfads.apps.xiaoyun.com';
const wxStatus = {
    'token': '',
    'ticket': '',
    'timestamp': null
};

const createNonceStr = function () {
    return Math.random().toString(36).substr(2, 15);
};

const createTimestamp = function () {
    return parseInt(new Date().getTime() / 1000) + '';
};

const raw = function (args) {
    var keys = Object.keys(args);
    keys = keys.sort()
    var newArgs = {};
    keys.forEach(function (key) {
        newArgs[key.toLowerCase()] = args[key];
    });

    var string = '';
    for (var k in newArgs) {
        string += '&' + k + '=' + newArgs[k];
    }
    string = string.substr(1);
    return string;
};

const sign = function (jsapi_ticket, url) {
    var ret = {
        jsapi_ticket: jsapi_ticket,
        nonceStr: createNonceStr(),
        timestamp: createTimestamp(),
        url: url
    };
    ret.signature = sha1(raw(ret));
    return {
        appid: appid,
        nonceStr: ret.nonceStr,
        timestamp: ret.timestamp,
        signature: ret.signature
    };
};

const getAccessToken = function (callback) {
    request.get({
        'url': `https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=${appid}&secret=${secret}`
    }, (err, res, body) => {
        if (!err && res.statusCode === 200) {
            body = JSON.parse(body);
            wxStatus['token'] = body.access_token;
            wxStatus['timestamp'] = createTimestamp();
        }
        callback(err);
    });
}

const getJsapiTicket = function (callback) {
    getAccessToken(function (err) {
        request.get({
            'url': `http://api.weixin.qq.com/cgi-bin/ticket/getticket?type=jsapi&access_token=${wxStatus['token']}`
        }, (err, res, body) => {
            if (!err && res.statusCode === 200) {
                body = JSON.parse(body);
                wxStatus['ticket'] = body.ticket;
            }
            callback(err);
        });
    });
}

const getWXSign = function (clientUrl, callback) {
    var nowTime = createTimestamp();
    var result = {};
    if (!wxStatus['timestamp'] || nowTime - wxStatus['timestamp'] > 7000) {
        getJsapiTicket(function (err) {
            if (err) {
                callback(err);
            }
            result = sign(wxStatus['ticket'], clientUrl);
            callback(null, result);
        });
    } else {
        result = sign(wxStatus['ticket'], clientUrl);
        callback(null, result);
    }
};

export {
    getWXSign,
    sign
}
