/* eslint-disable */
import 'babel-polyfill'
/* eslint-enable */
import Model from './model'

const create = async (options) => {
    options.createdAt = options.createdAt || Date.now()
    const result = await Model.create(Object.assign({}, options))
    return result
}
const find = async (options = {}, query = { limit: 25, skip: 1, createdAt: -1 }) => {
    if (!query.skip) {
        query.skip = 1
    }
    if (!query.limit) {
        query.limit = 25
    }
    if (!query.createdAt) {
        query.createdAt = -1
    }
    if (options.removed === undefined) {
        options.removed = false   
    }
    const result = await Model.find(options).sort({ createdAt: query.createdAt }).limit(query.limit).skip((query.skip - 1) * query.limit)
    return result
}
const remove = async (id) => {
    let analyse = await Model.findById(id)
    if (!analyse) {
        return null
    }
    analyse.removed = true
    analyse.updatedAt = Date.now()
    const result = await analyse.save()
    return result
}
const update = async (id, options = {}) => {
    let analyse = await Model.findById(id)
    if (!analyse) {
        return null
    }
    analyse = Object.assign({}, analyse, options)
    analyse.updatedAt = Date.now()
    const result = await analyse.save()
    return result
}
const count = async () => {
    const result = await Model.count({ removed: false })
    return result
}
export default {
    create,
    find,
    remove,
    update,
    count
}