window.onload = function () {
    if (window.applicationCache) {
        particlesJS.load('section0', 'js/particles.json');
    } else {
        $('#section0').css('backgroundImage', 'url(../images/section0_bg.png)')
        $('.page-tip').css('backgroundImage', 'url(../images/arrow.png)');
        $('#section5 input').css('backgroundImage', 'url(../images/phone.png)');
        $('.btn-submit').css({
            'height': '40px',
            'marginLeft': '10px',
            'lineHeight': '20px'
        });
        setInterval(animateTips, 1500);
        function animateTips () {
            $('.page-tip').css({
                'bottom': '60px',
                'opacity': 0
            }).animate({
                'bottom': '36px',
                'opacity': 1
            }, 750);
        }
        animateTips();
    }

    var flag = {
        industry: false,
        platform: false,
        format: false,
        expect: false
    };

    var expect = 0;
    var articles = 0;
    var days = 0;
    var money = 0;
    var cpm = 0;
    var articlesPv = 5000;
    var publishArticlesCount = 400;
    var scale = 0;

    function clickBtn (id, type) {
        if (type === 'checkbox') {
            $('#' + id).on('click', '.xy-btn', function () {
                if ($(this).hasClass('on')) {
                    $(this).removeClass('on');
                } else {
                    $(this).addClass('on');
                }
                if ($('#' + id + ' .xy-btn.on').length > 0) {
                    flag[id] = true;
                } else {
                    flag[id] = false;
                }
                checkFlag();
            });
        } else {
            $('#' + id).on('click', '.xy-btn', function () {
                $('#' + id + ' .xy-btn').removeClass('on');
                $(this).addClass('on');
                flag[id] = true;
                checkFlag();
            });
        }
    }
    function checkFlag () {
        if (flag.industry && flag.platform && flag.format && flag.expect) {
            compute();
        } else {
            $('#tips').show();
            $('#result').hide();
        }
    }
    function compute () {
        articles = Math.ceil(expect / articlesPv);
        days = Math.ceil(articles / publishArticlesCount);
        scale = $('#format .xy-btn.on').data('scale');
        cpm = $('#industry .xy-btn.on').data('cpm') * (scale / 10);
        money = expect / 1000 * Math.ceil(cpm);
        $('#money').html(money);
        $('#cpm').html(cpm);
        $('#articles').html(articles);
        $('#days').html(days);
        $('#tips').hide();
        $('#result').show();
    }
    function changeExpect (value) {
        expect = value * 10000;
        flag['expect'] = (!isNaN(expect) && expect > 0);
        checkFlag();
    }
    clickBtn('industry');
    clickBtn('platform');
    clickBtn('format');
    $('#expect').blur(function () {
        changeExpect(+$(this).val());
    });
    $(document).keypress(function (e) {
        if (e.which === 13) {
            changeExpect(+$('#expect').val());
        }
    });
};
