import mongoose from '../util/db'

const Schema = mongoose.Schema

const OrderSchema = new Schema({
    phone    : { type: String, required: true },
    createdAt: { type: Date, default: Date.now }, // 创建时间
    updatedAt: { type: Date, default: Date.now }, // 修改时间
    state    : { type: String, default: '' },
    content  : { type: Object, default: {} },
    removed  : { type: Boolean, default: false }
}, {
    collection: 'order'
})

export default mongoose.model('Order', OrderSchema)
