import Manager from './manager'

const limit = 25

const update = async (req, res, next) => {
    if (['success', 'fail', 'undetermined'].(req.body.state || '') === -1) {
        const err = new Error('参数不对')
        err.status = 400
        return next(err)
    }
    const result = await Manager.update(req.body.id, { state: req.body.state })
    if (!result) {
        const err = new Error('修改失败')
        err.status = 400
        return next(err)
    }
    res.redirect('/list')
}
const remove = async (req, res, next) => {
    const result = await Manager.remove(req.body.id)
    if (!result) {
        const err = new Error('删除失败')
        err.status = 400
        return next(err)
    }
    res.redirect('/list')
}
const findByPage = async (req, res, next) => {
    let currentPage = 1
    try {
        currentPage = parseInt(Number(req.query.p), 10) || 1
    } catch (err) {
        currentPage = 1
    }
    let results = await Manager.find({}, { limit, skip: currentPage })
    const countPage = Math.ceil(await Manager.count() / limit)
    res.render('list', { results, countPage, currentPage })
}
const create = async (req, res, next) => {
    const phone = req.body.phone
    const content = req.body.content || {}
    // 校验手机号
    const phoneReg = /^(((13[0-9]{1})|(15[0-9]{1})|(18[0-9]{1}))+\d{8})$/; 
    if (!phoneReg.test(phone)) {
        res.status(400).send({
            state: 'fail',
            message: '请输入合法的手机号'
        })
    }
    // 校验数据
    content.industry = content.industry || '' // 1.行业分类
    content.platform = content.platform || '' // 2.内容平台
    content.format = content.format || '' // 3.展现形式
    content.expect = content.expect || 0 // 4.预期阅读量
    let errorMsg = []
    // '社会', '娱乐', '健康', '美食', '汽车', '科技', '军事', '宠物', '文学', '时尚'
    if (['shehui', 'yule', 'jiankang', 'meishi', 'qiche', 'keji', 'junshi', 'chongwu', 'wenxue', 'shishang'].indexOf(content.industry) === -1) {
        errorMsg.push('行业分类数据不正确')
    }
    // '百度百家', '今日头条', '企鹅媒体平台', 'UC云管', '网易', '搜狐公众平台'
    if (['baijia', 'toutiao', 'qie', 'uc', 'wangyi', 'souhu'].indexOf(content.platform) === -1) {
        errorMsg.push('行业平台数据不正确')
    }
    // '段落植入', '软文广告', '图片植入'
    if (['dlzr', 'rwgg', 'tpzr'].indexOf(content.format) === -1) { // 段落植入、软文广告、图片植入
        errorMsg.push('展现形式数据不正确')
    }
    if (isNaN(content.expect) || content.expect <= 0) {
        errorMsg.push('展现阅读量数据不正确')
    }
    if (errorMsg.join(',') !== '') {
        return res.status(400).send({
            state: 'fail',
            message: errorMsg.join(',')
        })
    }
    const result = await Manager.create({
        phone,
        content  
    })
    if (!result) {
        res.status(400).send({
            state: 'fail',
            message: '提交失败'
        })
    } else {
        res.send({
            state: 'success',
            message: '提交成功'
        })
    }
}

export default {
    create,
    findByPage,
    update,
    remove
}
