const hash = require('../../utils/hash');
const mongoose = require('mongoose');
const {ObjectId} = mongoose.SchemaTypes;

const fengchaoadmin = mongoose.Schema({
    username: {
        type: String,
        unique: true,
        required: true
    },
    password: {
        type: String,
        required: true,
        set: v => hash(v)
    },
    session:{
        type: String,
        required: false,
    },
    level: {
        // 0: admin
        // 1: author
        // 2: redactor
        type: Number,
        default: 1
    }
}, {
    timestamps: true
});

// user.pre('save', async function (next) {
//     if (!this.isNew) return next();

//     this.id = await module.exports.count() + 1;
//     next();
// });

module.exports = mongoose.model('fengchaoadmin', fengchaoadmin);
