const mongoose = require('mongoose');
const {ObjectId} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    userId: {
        type: ObjectId,
        ref: 'user',
        required: true
    },
    platform: {
        type: String,
        required: false
    },
    nickname: {
        type: String,
        required: false
    },
    category: {
        type: String,
        required: false
    }
}, {
    timestamps: true
});

schema.index({userId: 1});
module.exports = mongoose.model('upstream-unbind-history', schema);
