const types = require('../actions/actionTypes');
const Cookies = require('js-cookie');
const _ = require('lodash');

const defaultData = {
    status: Cookies.get('sess') ? 'login' : 'logout', // waiting login,
    user: {
        username: Cookies.get('username'),
        password: null
    }
};

module.exports = function login (state = defaultData, action) {
    switch (action.type) {
    case types.LOGINSTATUS:
        return _.assign({}, state, {session: action.session, status: action.status, user: action.user});
    default:
        return state;
    }
};

