const React = require('react');
const connect = require('react-redux').connect;
const actions = require('../js/actions');

import {Card, Form, Icon, Input, Button, Checkbox} from 'antd';

const FormItem = Form.Item;

class Login extends React.Component{
	constructor(props){
		super(props);
	}

	componentWillMount(){
		if(this.props.login && this.props.login.status == 'login') 
			location.href = '/manage'
		const { dispatch } = this.props;
	}

	hasErrors(fieldsError) {
  		return Object.keys(fieldsError).some(field => fieldsError[field]);
	}

	handleSubmit(e){
		e.preventDefault();
        var data = {};
        this.props.form.validateFields((err, values) => {
	      if (!err) {
	        data = values;
	        this.props.dispatch(actions.getSession(data));
	      } 
	    });
	}

	render(){

		const { getFieldDecorator , getFieldsError } = this.props.form;
		return (
			<div className = 'login-wrapper'>
				<Card
					className = { 'm' }
					title = { '小云蜂巢admin' } 
					extra = { <span>登陆</span> }
					style = {{ width:400,margin:'auto' }}
				>   
					<Form className='login-form' onSubmit = { this.handleSubmit.bind(this) }>
						<FormItem>
					        { getFieldDecorator('username', {
					            rules: [{ required: true, message: '请输入正确账号' }],
					        })(
					            <Input prefix={<Icon type='user' style={{ fontSize: 13 }} />} placeholder='username' />
					          )}
				   		</FormItem>
				   		<FormItem>
				          	{getFieldDecorator('password', {
				            	rules: [{ required: true, message: '请输入密码' }],
				          	})(
				            	<Input prefix={<Icon type='lock' style={{ fontSize: 13 }} />} type='password' placeholder='password' />
				          	)}
				        </FormItem>
				        <FormItem>
				            <Button
				             className='login-form-button'
				             type='primary'
				             htmlType='submit'
				            >
				              登陆
				            </Button>
				        </FormItem>
					</Form>
				</Card>
			</div>
		)
	}
}

function mapStateToProps (state) {
	return state;
}

module.exports = connect(mapStateToProps)(Form.create()(Login));