'use strict'

var webpack = require('webpack');
var commonChunkPlugin = webpack.optimize.CommonsChunkPlugin;
module.exports = {
	entry:{
		app:['./app/js/index.js'],
		common: ['react', 'react-dom', 'jquery','lodash', 'redux', 'react-router', 'react-redux', 'react-router-redux-ie8']
	},
	output:{
		path:__dirname + '/app/built',
		publicPath: '/app/built/',
		filename:'[name].bundle.js',
		chunkFilename: '[id].chunk.js'
	},
	module:{
		loaders:[
			{
				test: /\.jsx?$/,
                loaders: ['babel-loader?cacheDirectory=' + __dirname + '/babelCache'],//babel缓存后 编译缩短至2s
                exclude: /node_modules|vendors/
			},
			{	test: /\.less$/,
				loader: 'style-loader!css-loader!less-loader'
			}, // use ! to chain loaders
            {	test: /\.css$/, 
            	loader: 'style-loader!css-loader!postcss-loader'
            }
		]
	},
	plugins:[
	    new commonChunkPlugin({ name: 'common' }),
		new webpack.BannerPlugin('This file is created by phyllis'),
		new webpack.optimize.UglifyJsPlugin({
                compress: {
                    warnings: false,
                    drop_console: false
                }
        })
	]
}