'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _function = require('react-pure-render/function');

var _function2 = _interopRequireDefault(_function);

var _reduxDevtools = require('redux-devtools');

var _LogMonitorButton = require('./LogMonitorButton');

var _LogMonitorButton2 = _interopRequireDefault(_LogMonitorButton);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var reset = _reduxDevtools.ActionCreators.reset;
var rollback = _reduxDevtools.ActionCreators.rollback;
var commit = _reduxDevtools.ActionCreators.commit;
var sweep = _reduxDevtools.ActionCreators.sweep;


var style = {
  textAlign: 'center',
  borderBottomWidth: 1,
  borderBottomStyle: 'solid',
  borderColor: 'transparent',
  zIndex: 1,
  display: 'flex',
  flexDirection: 'row'
};

var LogMonitorButtonBar = function (_Component) {
  _inherits(LogMonitorButtonBar, _Component);

  function LogMonitorButtonBar(props) {
    _classCallCheck(this, LogMonitorButtonBar);

    var _this = _possibleConstructorReturn(this, _Component.call(this, props));

    _this.shouldComponentUpdate = _function2.default;

    _this.handleReset = _this.handleReset.bind(_this);
    _this.handleRollback = _this.handleRollback.bind(_this);
    _this.handleSweep = _this.handleSweep.bind(_this);
    _this.handleCommit = _this.handleCommit.bind(_this);
    return _this;
  }

  LogMonitorButtonBar.prototype.handleRollback = function handleRollback() {
    this.props.dispatch(rollback());
  };

  LogMonitorButtonBar.prototype.handleSweep = function handleSweep() {
    this.props.dispatch(sweep());
  };

  LogMonitorButtonBar.prototype.handleCommit = function handleCommit() {
    this.props.dispatch(commit());
  };

  LogMonitorButtonBar.prototype.handleReset = function handleReset() {
    this.props.dispatch(reset());
  };

  LogMonitorButtonBar.prototype.render = function render() {
    var _props = this.props;
    var theme = _props.theme;
    var hasStates = _props.hasStates;
    var hasSkippedActions = _props.hasSkippedActions;

    return _react2.default.createElement(
      'div',
      { style: _extends({}, style, { borderColor: theme.base02 }) },
      _react2.default.createElement(
        _LogMonitorButton2.default,
        {
          theme: theme,
          onClick: this.handleReset,
          enabled: true },
        'Reset'
      ),
      _react2.default.createElement(
        _LogMonitorButton2.default,
        {
          theme: theme,
          onClick: this.handleRollback,
          enabled: hasStates },
        'Revert'
      ),
      _react2.default.createElement(
        _LogMonitorButton2.default,
        {
          theme: theme,
          onClick: this.handleSweep,
          enabled: hasSkippedActions },
        'Sweep'
      ),
      _react2.default.createElement(
        _LogMonitorButton2.default,
        {
          theme: theme,
          onClick: this.handleCommit,
          enabled: hasStates },
        'Commit'
      )
    );
  };

  return LogMonitorButtonBar;
}(_react.Component);

LogMonitorButtonBar.propTypes = {
  dispatch: _react.PropTypes.func,
  theme: _react.PropTypes.object
};
exports.default = LogMonitorButtonBar;