'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _function = require('react-pure-render/function');

var _function2 = _interopRequireDefault(_function);

var _reduxDevtoolsThemes = require('redux-devtools-themes');

var themes = _interopRequireWildcard(_reduxDevtoolsThemes);

var _reduxDevtools = require('redux-devtools');

var _actions = require('./actions');

var _reducers = require('./reducers');

var _reducers2 = _interopRequireDefault(_reducers);

var _LogMonitorButtonBar = require('./LogMonitorButtonBar');

var _LogMonitorButtonBar2 = _interopRequireDefault(_LogMonitorButtonBar);

var _LogMonitorEntryList = require('./LogMonitorEntryList');

var _LogMonitorEntryList2 = _interopRequireDefault(_LogMonitorEntryList);

var _lodash = require('lodash.debounce');

var _lodash2 = _interopRequireDefault(_lodash);

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj.default = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var toggleAction = _reduxDevtools.ActionCreators.toggleAction;
var setActionsActive = _reduxDevtools.ActionCreators.setActionsActive;


var styles = {
  container: {
    fontFamily: 'monaco, Consolas, Lucida Console, monospace',
    position: 'relative',
    overflowY: 'hidden',
    width: '100%',
    height: '100%',
    minWidth: 300,
    direction: 'ltr'
  },
  elements: {
    position: 'absolute',
    left: 0,
    right: 0,
    top: 0,
    bottom: 0,
    overflowX: 'hidden',
    overflowY: 'auto'
  }
};

var LogMonitor = function (_Component) {
  _inherits(LogMonitor, _Component);

  function LogMonitor(props) {
    _classCallCheck(this, LogMonitor);

    var _this = _possibleConstructorReturn(this, _Component.call(this, props));

    _this.shouldComponentUpdate = _function2.default;
    _this.updateScrollTop = (0, _lodash2.default)(function () {
      var node = _this.node;
      _this.props.dispatch((0, _actions.updateScrollTop)(node ? node.scrollTop : 0));
    }, 500);

    _this.handleToggleAction = _this.handleToggleAction.bind(_this);
    _this.handleToggleConsecutiveAction = _this.handleToggleConsecutiveAction.bind(_this);
    _this.getRef = _this.getRef.bind(_this);
    return _this;
  }

  LogMonitor.prototype.scroll = function scroll() {
    var node = this.node;
    if (!node) {
      return;
    }
    if (this.scrollDown) {
      var offsetHeight = node.offsetHeight;
      var scrollHeight = node.scrollHeight;

      node.scrollTop = scrollHeight - offsetHeight;
      this.scrollDown = false;
    }
  };

  LogMonitor.prototype.componentDidMount = function componentDidMount() {
    var node = this.node;
    if (!node || !this.props.monitorState) {
      return;
    }

    if (this.props.preserveScrollTop) {
      node.scrollTop = this.props.monitorState.initialScrollTop;
      node.addEventListener('scroll', this.updateScrollTop);
    } else {
      this.scrollDown = true;
      this.scroll();
    }
  };

  LogMonitor.prototype.componentWillUnmount = function componentWillUnmount() {
    var node = this.node;
    if (node && this.props.preserveScrollTop) {
      node.removeEventListener('scroll', this.updateScrollTop);
    }
  };

  LogMonitor.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    var node = this.node;
    if (!node) {
      this.scrollDown = true;
    } else if (this.props.stagedActionIds.length < nextProps.stagedActionIds.length) {
      var scrollTop = node.scrollTop;
      var offsetHeight = node.offsetHeight;
      var scrollHeight = node.scrollHeight;


      this.scrollDown = Math.abs(scrollHeight - (scrollTop + offsetHeight)) < 20;
    } else {
      this.scrollDown = false;
    }
  };

  LogMonitor.prototype.componentDidUpdate = function componentDidUpdate() {
    this.scroll();
  };

  LogMonitor.prototype.handleToggleAction = function handleToggleAction(id) {
    this.props.dispatch(toggleAction(id));
  };

  LogMonitor.prototype.handleToggleConsecutiveAction = function handleToggleConsecutiveAction(id) {
    var _props = this.props;
    var monitorState = _props.monitorState;
    var actionsById = _props.actionsById;
    var consecutiveToggleStartId = monitorState.consecutiveToggleStartId;

    if (consecutiveToggleStartId && actionsById[consecutiveToggleStartId]) {
      var skippedActionIds = this.props.skippedActionIds;

      var start = Math.min(consecutiveToggleStartId, id);
      var end = Math.max(consecutiveToggleStartId, id);
      var active = skippedActionIds.indexOf(consecutiveToggleStartId) > -1;
      this.props.dispatch(setActionsActive(start, end + 1, active));
      this.props.dispatch((0, _actions.startConsecutiveToggle)(null));
    } else if (id > 0) {
      this.props.dispatch((0, _actions.startConsecutiveToggle)(id));
    }
  };

  LogMonitor.prototype.getTheme = function getTheme() {
    var theme = this.props.theme;

    if (typeof theme !== 'string') {
      return theme;
    }

    if (typeof themes[theme] !== 'undefined') {
      return themes[theme];
    }

    console.warn('DevTools theme ' + theme + ' not found, defaulting to nicinabox');
    return themes.nicinabox;
  };

  LogMonitor.prototype.getRef = function getRef(node) {
    this.node = node;
  };

  LogMonitor.prototype.render = function render() {
    var theme = this.getTheme();
    var consecutiveToggleStartId = this.props.monitorState.consecutiveToggleStartId;
    var _props2 = this.props;
    var dispatch = _props2.dispatch;
    var actionsById = _props2.actionsById;
    var skippedActionIds = _props2.skippedActionIds;
    var stagedActionIds = _props2.stagedActionIds;
    var computedStates = _props2.computedStates;
    var currentStateIndex = _props2.currentStateIndex;
    var select = _props2.select;
    var expandActionRoot = _props2.expandActionRoot;
    var expandStateRoot = _props2.expandStateRoot;
    var markStateDiff = _props2.markStateDiff;


    var entryListProps = {
      theme: theme,
      actionsById: actionsById,
      skippedActionIds: skippedActionIds,
      stagedActionIds: stagedActionIds,
      computedStates: computedStates,
      currentStateIndex: currentStateIndex,
      consecutiveToggleStartId: consecutiveToggleStartId,
      select: select,
      expandActionRoot: expandActionRoot,
      expandStateRoot: expandStateRoot,
      markStateDiff: markStateDiff,
      onActionClick: this.handleToggleAction,
      onActionShiftClick: this.handleToggleConsecutiveAction
    };

    return _react2.default.createElement(
      'div',
      { style: _extends({}, styles.container, { backgroundColor: theme.base00 }) },
      !this.props.hideMainButtons && _react2.default.createElement(_LogMonitorButtonBar2.default, {
        theme: theme,
        dispatch: dispatch,
        hasStates: computedStates.length > 1,
        hasSkippedActions: skippedActionIds.length > 0
      }),
      _react2.default.createElement(
        'div',
        {
          style: this.props.hideMainButtons ? styles.elements : _extends({}, styles.elements, { top: 30 }),
          ref: this.getRef
        },
        _react2.default.createElement(_LogMonitorEntryList2.default, entryListProps)
      )
    );
  };

  return LogMonitor;
}(_react.Component);

LogMonitor.update = _reducers2.default;
LogMonitor.propTypes = {
  dispatch: _react.PropTypes.func,
  computedStates: _react.PropTypes.array,
  actionsById: _react.PropTypes.object,
  stagedActionIds: _react.PropTypes.array,
  skippedActionIds: _react.PropTypes.array,
  monitorState: _react.PropTypes.shape({
    initialScrollTop: _react.PropTypes.number,
    consecutiveToggleStartId: _react.PropTypes.number
  }),

  preserveScrollTop: _react.PropTypes.bool,
  select: _react.PropTypes.func,
  theme: _react.PropTypes.oneOfType([_react.PropTypes.object, _react.PropTypes.string]),
  expandActionRoot: _react.PropTypes.bool,
  expandStateRoot: _react.PropTypes.bool,
  markStateDiff: _react.PropTypes.bool,
  hideMainButtons: _react.PropTypes.bool
};
LogMonitor.defaultProps = {
  select: function select(state) {
    return state;
  },
  theme: 'nicinabox',
  preserveScrollTop: true,
  expandActionRoot: true,
  expandStateRoot: true,
  markStateDiff: false
};
exports.default = LogMonitor;