'use strict';

exports.__esModule = true;
exports['default'] = undefined;

var _objectWithoutProperties2 = require('babel-runtime/helpers/objectWithoutProperties');

var _objectWithoutProperties3 = _interopRequireDefault(_objectWithoutProperties2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _keys = require('babel-runtime/core-js/object/keys');

var _keys2 = _interopRequireDefault(_keys);

var _class, _temp; // ES6 + inline style port of JSONViewer https://bitbucket.org/davevedder/react-json-viewer/
// all credits and original code to the author
// Dave Vedder <veddermatic@gmail.com> http://www.eskimospy.com/
// port by Daniele Zannotti http://www.github.com/dzannotti <dzannotti@me.com>

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _JSONNode = require('./JSONNode');

var _JSONNode2 = _interopRequireDefault(_JSONNode);

var _createStylingFromTheme = require('./createStylingFromTheme');

var _createStylingFromTheme2 = _interopRequireDefault(_createStylingFromTheme);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var identity = function identity(value) {
  return value;
};

function checkLegacyTheming(theme, props) {
  var deprecatedStylingMethodsMap = {
    getArrowStyle: 'arrow',
    getListStyle: 'nestedNodeChildren',
    getItemStringStyle: 'nestedNodeItemString',
    getLabelStyle: 'label',
    getValueStyle: 'valueText'
  };

  var deprecatedStylingMethods = (0, _keys2['default'])(deprecatedStylingMethodsMap).filter(function (name) {
    return props[name];
  });

  if (deprecatedStylingMethods.length > 0) {
    if (typeof theme === 'string') {
      theme = {
        extend: theme
      };
    } else {
      theme = (0, _extends3['default'])({}, theme);
    }

    deprecatedStylingMethods.forEach(function (name) {
      console.error( // eslint-disable-line no-console
      'Styling method "' + name + '" is deprecated, use "theme" property instead');

      theme[deprecatedStylingMethodsMap[name]] = function (_ref) {
        for (var _len = arguments.length, args = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        var style = _ref.style;
        return {
          style: (0, _extends3['default'])({}, style, props[name].apply(props, args))
        };
      };
    });
  }

  return theme;
}

var JSONTree = (_temp = _class = function (_React$Component) {
  (0, _inherits3['default'])(JSONTree, _React$Component);

  function JSONTree() {
    (0, _classCallCheck3['default'])(this, JSONTree);
    return (0, _possibleConstructorReturn3['default'])(this, _React$Component.apply(this, arguments));
  }

  JSONTree.prototype.render = function render() {
    var _props = this.props;
    var value = _props.data;
    var expandRoot = _props.expandRoot;
    var expandAll = _props.expandAll;
    var keyPath = _props.keyPath;
    var postprocessValue = _props.postprocessValue;
    var hideRoot = _props.hideRoot;
    var theme = _props.theme;
    var isLightTheme = _props.isLightTheme;
    var rest = (0, _objectWithoutProperties3['default'])(_props, ['data', 'expandRoot', 'expandAll', 'keyPath', 'postprocessValue', 'hideRoot', 'theme', 'isLightTheme']);


    if (typeof expandRoot !== 'undefined') {
      console.error( // eslint-disable-line no-console
      'The expandRoot property is deprecated, use "shouldExpandNode: () => false" instead');
    }

    if (typeof expandAll !== 'undefined') {
      console.error( // eslint-disable-line no-console
      'The expandAll property is deprecated, use "shouldExpandNode: () => true" instead');
    }

    var styling = (0, _createStylingFromTheme2['default'])(checkLegacyTheming(theme, rest), null, isLightTheme);

    return _react2['default'].createElement(
      'ul',
      styling('tree'),
      _react2['default'].createElement(_JSONNode2['default'], (0, _extends3['default'])({}, (0, _extends3['default'])({ postprocessValue: postprocessValue, hideRoot: hideRoot, styling: styling }, rest), {
        initialExpanded: typeof expandRoot === 'undefined' ? true : expandRoot,
        allExpanded: typeof expandAll === 'undefined' ? false : expandAll,
        keyPath: hideRoot ? [] : keyPath,
        value: postprocessValue(value)
      }))
    );
  };

  return JSONTree;
}(_react2['default'].Component), _class.propTypes = {
  data: _react.PropTypes.oneOfType([_react.PropTypes.array, _react.PropTypes.object]).isRequired,
  hideRoot: _react.PropTypes.bool,
  theme: _react.PropTypes.oneOfType([_react.PropTypes.object, _react.PropTypes.string]),
  isLightTheme: _react.PropTypes.bool,
  expandRoot: _react.PropTypes.bool,
  expandAll: _react.PropTypes.bool,
  keyPath: _react.PropTypes.arrayOf(_react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.number])),
  postprocessValue: _react.PropTypes.func,
  sortObjectKeys: _react.PropTypes.oneOfType([_react.PropTypes.func, _react.PropTypes.bool])
}, _class.defaultProps = {
  shouldExpandNode: function shouldExpandNode(keyName, data, level) {
    return level === 0;
  }, // expands root by default,
  hideRoot: false,
  keyPath: ['root'],
  getItemString: function getItemString(type, data, itemType, itemString) {
    return _react2['default'].createElement(
      'span',
      null,
      itemType,
      ' ',
      itemString
    );
  },
  labelRenderer: identity,
  valueRenderer: identity,
  postprocessValue: identity,
  isCustomNode: function isCustomNode() {
    return false;
  },
  collectionLimit: 50,
  isLightTheme: true
}, _temp);
exports['default'] = JSONTree;