'use strict';

exports.__esModule = true;

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _solarized = require('./themes/solarized');

var _solarized2 = _interopRequireDefault(_solarized);

var _reactBase16Styling = require('react-base16-styling');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var colorMap = function colorMap(theme) {
  return {
    BACKGROUND_COLOR: theme.base00,
    TEXT_COLOR: theme.base07,
    STRING_COLOR: theme.base0B,
    DATE_COLOR: theme.base0B,
    NUMBER_COLOR: theme.base09,
    BOOLEAN_COLOR: theme.base09,
    NULL_COLOR: theme.base08,
    UNDEFINED_COLOR: theme.base08,
    FUNCTION_COLOR: theme.base08,
    SYMBOL_COLOR: theme.base08,
    LABEL_COLOR: theme.base0D,
    ARROW_COLOR: theme.base0D,
    ITEM_STRING_COLOR: theme.base0B,
    ITEM_STRING_EXPANDED_COLOR: theme.base03
  };
};

var valueColorMap = function valueColorMap(colors) {
  return {
    String: colors.STRING_COLOR,
    Date: colors.DATE_COLOR,
    Number: colors.NUMBER_COLOR,
    Boolean: colors.BOOLEAN_COLOR,
    Null: colors.NULL_COLOR,
    Undefined: colors.UNDEFINED_COLOR,
    Function: colors.FUNCTION_COLOR,
    Symbol: colors.SYMBOL_COLOR
  };
};

var getDefaultThemeStyling = function getDefaultThemeStyling(theme) {
  var colors = colorMap(theme);

  return {
    tree: {
      border: 0,
      padding: 0,
      marginTop: 8,
      marginBottom: 8,
      marginLeft: 2,
      marginRight: 0,
      fontSize: '0.90em',
      listStyle: 'none',
      MozUserSelect: 'none',
      WebkitUserSelect: 'none',
      backgroundColor: colors.BACKGROUND_COLOR
    },

    value: {
      paddingTop: 3,
      paddingBottom: 3,
      paddingRight: 0,
      marginLeft: 14,
      WebkitUserSelect: 'text',
      MozUserSelect: 'text',
      wordWrap: 'break-word',
      paddingLeft: 34,
      textIndent: -7,
      wordBreak: 'break-all'
    },

    label: {
      display: 'inline-block',
      color: colors.LABEL_COLOR
    },

    valueLabel: {
      marginRight: 5
    },

    valueText: function valueText(_ref, nodeType) {
      var style = _ref.style;
      return {
        style: (0, _extends3['default'])({}, style, {
          color: valueColorMap(colors)[nodeType]
        })
      };
    },

    itemRange: {
      marginBottom: 8,
      cursor: 'pointer',
      color: colors.LABEL_COLOR
    },

    arrow: function arrow(_ref2, nodeType, expanded) {
      var style = _ref2.style;
      return {
        style: (0, _extends3['default'])({}, style, {
          display: 'inline-block',
          marginLeft: 0,
          marginTop: 8,
          float: 'left',
          transition: '150ms',
          WebkitTransition: '150ms',
          MozTransition: '150ms',
          WebkitTransform: expanded ? 'rotateZ(0deg)' : 'rotateZ(-90deg)',
          MozTransform: expanded ? 'rotateZ(0deg)' : 'rotateZ(-90deg)',
          transform: expanded ? 'rotateZ(0deg)' : 'rotateZ(-90deg)',
          position: 'relative'
        })
      };
    },

    arrowContainer: function arrowContainer(_ref3, arrowStyle) {
      var style = _ref3.style;
      return {
        style: (0, _extends3['default'])({}, style, {
          display: 'inline-block',
          paddingTop: 2,
          paddingBottom: 2,
          paddingRight: arrowStyle === 'double' ? 12 : 5,
          paddingLeft: arrowStyle === 'double' ? 12 : 5,
          cursor: 'pointer'
        })
      };
    },

    arrowSign: {
      borderLeft: '5px solid transparent',
      borderRight: '5px solid transparent',
      borderTopWidth: 5,
      borderTopStyle: 'solid',
      borderTopColor: colors.ARROW_COLOR
    },

    arrowSignInner: {
      position: 'absolute',
      top: 0,
      left: -5
    },

    nestedNode: {
      position: 'relative',
      paddingTop: 3,
      paddingBottom: 3,
      marginLeft: 14
    },

    rootNode: {
      padding: 0,
      margin: 0
    },

    nestedNodeLabel: {
      margin: 0,
      padding: 0,
      cursor: 'pointer'
    },

    nestedNodeItemString: function nestedNodeItemString(_ref4, nodeType, expanded) {
      var style = _ref4.style;
      return {
        style: (0, _extends3['default'])({}, style, {
          cursor: 'default',
          color: expanded ? colors.ITEM_STRING_EXPANDED_COLOR : colors.ITEM_STRING_COLOR
        })
      };
    },

    nestedNodeItemType: {
      marginLeft: 5,
      marginRight: 5
    },

    nestedNodeChildren: function nestedNodeChildren(_ref5, nodeType, expanded) {
      var style = _ref5.style;
      return {
        style: (0, _extends3['default'])({}, style, {
          padding: 0,
          margin: 0,
          listStyle: 'none',
          display: expanded ? 'block' : 'none'
        })
      };
    },

    rootNodeChildren: {
      padding: 0,
      margin: 0,
      listStyle: 'none'
    }
  };
};

exports['default'] = (0, _reactBase16Styling.createStyling)({
  getStylingFromBase16: getDefaultThemeStyling,
  defaultBase16: _solarized2['default']
});