'use strict';

exports.__esModule = true;
exports['default'] = undefined;

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _extends2 = require('babel-runtime/helpers/extends');

var _extends3 = _interopRequireDefault(_extends2);

var _class, _temp;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _JSONArrow = require('./JSONArrow');

var _JSONArrow2 = _interopRequireDefault(_JSONArrow);

var _getCollectionEntries = require('./getCollectionEntries');

var _getCollectionEntries2 = _interopRequireDefault(_getCollectionEntries);

var _JSONNode = require('./JSONNode');

var _JSONNode2 = _interopRequireDefault(_JSONNode);

var _ItemRange = require('./ItemRange');

var _ItemRange2 = _interopRequireDefault(_ItemRange);

var _function = require('react-pure-render/function');

var _function2 = _interopRequireDefault(_function);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

/**
 * Renders nested values (eg. objects, arrays, lists, etc.)
 */

function renderChildNodes(props, from, to) {
  var nodeType = props.nodeType;
  var data = props.data;
  var collectionLimit = props.collectionLimit;
  var circularCache = props.circularCache;
  var keyPath = props.keyPath;
  var postprocessValue = props.postprocessValue;
  var allExpanded = props.allExpanded;
  var sortObjectKeys = props.sortObjectKeys;

  var childNodes = [];

  (0, _getCollectionEntries2['default'])(nodeType, data, sortObjectKeys, collectionLimit, from, to).forEach(function (entry) {
    if (entry.to) {
      childNodes.push(_react2['default'].createElement(_ItemRange2['default'], (0, _extends3['default'])({}, props, {
        key: 'ItemRange--' + entry.from + '-' + entry.to,
        from: entry.from,
        to: entry.to,
        renderChildNodes: renderChildNodes
      })));
    } else {
      var key = entry.key;
      var value = entry.value;

      var isCircular = circularCache.indexOf(value) !== -1;

      var node = _react2['default'].createElement(_JSONNode2['default'], (0, _extends3['default'])({}, props, { postprocessValue: postprocessValue, collectionLimit: collectionLimit }, {
        key: 'Node--' + key,
        keyPath: [key].concat(keyPath),
        value: postprocessValue(value),
        circularCache: [].concat(circularCache, [value]),
        initialExpanded: false,
        allExpanded: isCircular ? false : allExpanded,
        hideRoot: false
      }));

      if (node !== false) {
        childNodes.push(node);
      }
    }
  });

  return childNodes;
}

var JSONNestedNode = (_temp = _class = function (_React$Component) {
  (0, _inherits3['default'])(JSONNestedNode, _React$Component);

  function JSONNestedNode(props) {
    (0, _classCallCheck3['default'])(this, JSONNestedNode);


    // calculate individual node expansion if necessary

    var _this = (0, _possibleConstructorReturn3['default'])(this, _React$Component.call(this, props));

    _this.shouldComponentUpdate = _function2['default'];

    _this.handleClick = function () {
      return _this.setState({ expanded: !_this.state.expanded });
    };

    var shouldExpandNode = props.shouldExpandNode ? props.shouldExpandNode(props.keyPath, props.data, props.level) : false;
    _this.state = {
      expanded: props.initialExpanded || props.allExpanded || shouldExpandNode,
      createdChildNodes: false
    };
    return _this;
  }

  JSONNestedNode.prototype.render = function render() {
    var _props = this.props;
    var getItemString = _props.getItemString;
    var nodeTypeIndicator = _props.nodeTypeIndicator;
    var nodeType = _props.nodeType;
    var data = _props.data;
    var hideRoot = _props.hideRoot;
    var createItemString = _props.createItemString;
    var styling = _props.styling;
    var collectionLimit = _props.collectionLimit;
    var keyPath = _props.keyPath;
    var labelRenderer = _props.labelRenderer;

    var expanded = this.state.expanded;
    var renderedChildren = expanded ? renderChildNodes((0, _extends3['default'])({}, this.props, { level: this.props.level + 1 })) : null;

    var itemType = _react2['default'].createElement(
      'span',
      styling('nestedNodeItemType', expanded),
      nodeTypeIndicator
    );
    var renderedItemString = getItemString(nodeType, data, itemType, createItemString(data, collectionLimit));
    var stylingArgs = [nodeType, expanded, keyPath];

    return hideRoot ? _react2['default'].createElement(
      'li',
      styling.apply(undefined, ['rootNode'].concat(stylingArgs)),
      _react2['default'].createElement(
        'ul',
        styling.apply(undefined, ['rootNodeChildren'].concat(stylingArgs)),
        renderedChildren
      )
    ) : _react2['default'].createElement(
      'li',
      styling.apply(undefined, ['nestedNode'].concat(stylingArgs)),
      _react2['default'].createElement(_JSONArrow2['default'], {
        styling: styling,
        nodeType: nodeType,
        expanded: expanded,
        onClick: this.handleClick
      }),
      _react2['default'].createElement(
        'label',
        (0, _extends3['default'])({}, styling.apply(undefined, [['label', 'nestedNodeLabel']].concat(stylingArgs)), {
          onClick: this.handleClick.bind(this)
        }),
        labelRenderer.apply(undefined, keyPath),
        ':'
      ),
      _react2['default'].createElement(
        'span',
        (0, _extends3['default'])({}, styling.apply(undefined, ['nestedNodeItemString'].concat(stylingArgs)), {
          onClick: this.handleClick
        }),
        renderedItemString
      ),
      _react2['default'].createElement(
        'ul',
        styling.apply(undefined, ['nestedNodeChildren'].concat(stylingArgs)),
        renderedChildren
      )
    );
  };

  return JSONNestedNode;
}(_react2['default'].Component), _class.propTypes = {
  getItemString: _react.PropTypes.func.isRequired,
  nodeTypeIndicator: _react.PropTypes.any,
  nodeType: _react.PropTypes.string.isRequired,
  data: _react.PropTypes.any,
  hideRoot: _react.PropTypes.bool.isRequired,
  createItemString: _react.PropTypes.func.isRequired,
  styling: _react.PropTypes.func.isRequired,
  collectionLimit: _react.PropTypes.number,
  keyPath: _react.PropTypes.arrayOf(_react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.number])).isRequired,
  labelRenderer: _react.PropTypes.func.isRequired,
  shouldExpandNode: _react.PropTypes.func,
  level: _react.PropTypes.number.isRequired,
  initialExpanded: _react.PropTypes.bool,
  allExpanded: _react.PropTypes.bool,
  sortObjectKeys: _react.PropTypes.oneOfType([_react.PropTypes.func, _react.PropTypes.bool])
}, _class.defaultProps = {
  data: [],
  initialExpanded: false,
  allExpanded: false,
  circularCache: [],
  level: 0
}, _temp);
exports['default'] = JSONNestedNode;