'use strict';

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRedux = require('react-redux');

var _reduxDevtoolsInstrument = require('redux-devtools-instrument');

var _reduxDevtoolsInstrument2 = _interopRequireDefault(_reduxDevtoolsInstrument);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

exports.createDevTools = function createDevTools(children) {
  var _class, _temp;

  var monitorElement = _react.Children.only(children);
  var monitorProps = monitorElement.props;
  var Monitor = monitorElement.type;
  var ConnectedMonitor = (0, _reactRedux.connect)(function (state) {
    return state;
  })(Monitor);

  return _temp = _class = function (_Component) {
    _inherits(DevTools, _Component);

    function DevTools(props, context) {
      _classCallCheck(this, DevTools);

      var _this = _possibleConstructorReturn(this, _Component.call(this, props, context));

      if (!props.store && !context.store) {
        console.error('Redux DevTools could not render. You must pass the Redux store ' + 'to <DevTools> either as a "store" prop or by wrapping it in a ' + '<Provider store={store}>.');
        return _possibleConstructorReturn(_this);
      }

      if (context.store) {
        _this.liftedStore = context.store.liftedStore;
      } else {
        _this.liftedStore = props.store.liftedStore;
      }

      if (!_this.liftedStore) {
        console.error('Redux DevTools could not render. Did you forget to include ' + 'DevTools.instrument() in your store enhancer chain before ' + 'using createStore()?');
      }
      return _this;
    }

    DevTools.prototype.render = function render() {
      if (!this.liftedStore) {
        return null;
      }

      return _react2.default.createElement(ConnectedMonitor, _extends({}, monitorProps, {
        store: this.liftedStore }));
    };

    return DevTools;
  }(_react.Component), _class.contextTypes = {
    store: _react.PropTypes.object
  }, _class.propTypes = {
    store: _react.PropTypes.object
  }, _class.instrument = function (options) {
    return (0, _reduxDevtoolsInstrument2.default)(function (state, action) {
      return Monitor.update(monitorProps, state, action);
    }, options);
  }, _temp;
};