'use strict';

exports.__esModule = true;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDock = require('react-dock');

var _reactDock2 = _interopRequireDefault(_reactDock);

var _constants = require('./constants');

var _actions = require('./actions');

var _reducers = require('./reducers');

var _reducers2 = _interopRequireDefault(_reducers);

var _parseKey = require('parse-key');

var _parseKey2 = _interopRequireDefault(_parseKey);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var DockMonitor = function (_Component) {
  _inherits(DockMonitor, _Component);

  function DockMonitor(props) {
    _classCallCheck(this, DockMonitor);

    var _this = _possibleConstructorReturn(this, _Component.call(this, props));

    _this.handleKeyDown = _this.handleKeyDown.bind(_this);
    _this.handleSizeChange = _this.handleSizeChange.bind(_this);

    var childrenCount = _react.Children.count(props.children);
    if (childrenCount === 0) {
      console.error('<DockMonitor> requires at least one monitor inside. ' + 'Why don’t you try <LogMonitor>? You can get it at ' + 'https://github.com/gaearon/redux-devtools-log-monitor.');
    } else if (childrenCount > 1 && !props.changeMonitorKey) {
      console.error('You specified multiple monitors inside <DockMonitor> ' + 'but did not provide `changeMonitorKey` prop to change them. ' + 'Try specifying <DockMonitor changeMonitorKey="ctrl-m" /> ' + 'and then press Ctrl-M.');
    }
    return _this;
  }

  DockMonitor.prototype.componentDidMount = function componentDidMount() {
    window.addEventListener('keydown', this.handleKeyDown);
  };

  DockMonitor.prototype.componentWillUnmount = function componentWillUnmount() {
    window.removeEventListener('keydown', this.handleKeyDown);
  };

  DockMonitor.prototype.matchesKey = function matchesKey(key, event) {
    if (!key) {
      return false;
    }

    var charCode = event.keyCode || event.which;
    var char = String.fromCharCode(charCode);
    return key.name.toUpperCase() === char.toUpperCase() && key.alt === event.altKey && key.ctrl === event.ctrlKey && key.meta === event.metaKey && key.shift === event.shiftKey;
  };

  DockMonitor.prototype.handleKeyDown = function handleKeyDown(e) {
    // Ignore regular keys when focused on a field
    // and no modifiers are active.
    if (!e.ctrlKey && !e.metaKey && !e.altKey && (e.target.tagName === 'INPUT' || e.target.tagName === 'SELECT' || e.target.tagName === 'TEXTAREA' || e.target.isContentEditable)) {
      return;
    }

    var visibilityKey = (0, _parseKey2.default)(this.props.toggleVisibilityKey);
    var positionKey = (0, _parseKey2.default)(this.props.changePositionKey);

    var monitorKey = void 0;
    if (this.props.changeMonitorKey) {
      monitorKey = (0, _parseKey2.default)(this.props.changeMonitorKey);
    }

    if (this.matchesKey(visibilityKey, e)) {
      e.preventDefault();
      this.props.dispatch((0, _actions.toggleVisibility)());
    } else if (this.matchesKey(positionKey, e)) {
      e.preventDefault();
      this.props.dispatch((0, _actions.changePosition)());
    } else if (this.matchesKey(monitorKey, e)) {
      e.preventDefault();
      this.props.dispatch((0, _actions.changeMonitor)());
    }
  };

  DockMonitor.prototype.handleSizeChange = function handleSizeChange(requestedSize) {
    this.props.dispatch((0, _actions.changeSize)(requestedSize));
  };

  DockMonitor.prototype.renderChild = function renderChild(child, index, otherProps) {
    var monitorState = this.props.monitorState;
    var childMonitorIndex = monitorState.childMonitorIndex;
    var childMonitorStates = monitorState.childMonitorStates;


    if (index !== childMonitorIndex) {
      return null;
    }

    return (0, _react.cloneElement)(child, _extends({
      monitorState: childMonitorStates[index]
    }, otherProps));
  };

  DockMonitor.prototype.render = function render() {
    var _this2 = this;

    var _props = this.props;
    var monitorState = _props.monitorState;
    var children = _props.children;
    var fluid = _props.fluid;

    var rest = _objectWithoutProperties(_props, ['monitorState', 'children', 'fluid']);

    var position = monitorState.position;
    var isVisible = monitorState.isVisible;
    var size = monitorState.size;


    return _react2.default.createElement(
      _reactDock2.default,
      { position: position,
        isVisible: isVisible,
        size: size,
        fluid: fluid,
        onSizeChange: this.handleSizeChange,
        dimMode: 'none' },
      _react.Children.map(children, function (child, index) {
        return _this2.renderChild(child, index, rest);
      })
    );
  };

  return DockMonitor;
}(_react.Component);

DockMonitor.update = _reducers2.default;
DockMonitor.propTypes = {
  defaultPosition: _react.PropTypes.oneOf(_constants.POSITIONS).isRequired,
  defaultIsVisible: _react.PropTypes.bool.isRequired,
  defaultSize: _react.PropTypes.number.isRequired,
  toggleVisibilityKey: _react.PropTypes.string.isRequired,
  changePositionKey: _react.PropTypes.string.isRequired,
  changeMonitorKey: _react.PropTypes.string,
  fluid: _react.PropTypes.bool,

  dispatch: _react.PropTypes.func,
  monitorState: _react.PropTypes.shape({
    position: _react.PropTypes.oneOf(_constants.POSITIONS).isRequired,
    size: _react.PropTypes.number.isRequired,
    isVisible: _react.PropTypes.bool.isRequired,
    childMonitorState: _react.PropTypes.any
  })
};
DockMonitor.defaultProps = {
  defaultIsVisible: true,
  defaultPosition: 'right',
  defaultSize: 0.3,
  fluid: true
};
exports.default = DockMonitor;