'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _TableCell = require('./TableCell');

var _TableCell2 = _interopRequireDefault(_TableCell);

var _ExpandIcon = require('./ExpandIcon');

var _ExpandIcon2 = _interopRequireDefault(_ExpandIcon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defaults(obj, defaults) { var keys = Object.getOwnPropertyNames(defaults); for (var i = 0; i < keys.length; i++) { var key = keys[i]; var value = Object.getOwnPropertyDescriptor(defaults, key); if (value && value.configurable && obj[key] === undefined) { Object.defineProperty(obj, key, value); } } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass); }

var TableRow = function (_React$Component) {
  _inherits(TableRow, _React$Component);

  function TableRow() {
    var _temp, _this, _ret;

    _classCallCheck(this, TableRow);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, _React$Component.call.apply(_React$Component, [this].concat(args))), _this), _this.state = {
      hovered: false
    }, _this.onRowClick = function (event) {
      var _this$props = _this.props,
          record = _this$props.record,
          index = _this$props.index,
          onRowClick = _this$props.onRowClick,
          expandable = _this$props.expandable,
          expandRowByClick = _this$props.expandRowByClick,
          expanded = _this$props.expanded,
          onExpand = _this$props.onExpand;

      if (expandable && expandRowByClick) {
        onExpand(!expanded, record, event, index);
      }
      onRowClick(record, index, event);
    }, _this.onRowDoubleClick = function (event) {
      var _this$props2 = _this.props,
          record = _this$props2.record,
          index = _this$props2.index,
          onRowDoubleClick = _this$props2.onRowDoubleClick;

      onRowDoubleClick(record, index, event);
    }, _this.onMouseEnter = function () {
      var _this$props3 = _this.props,
          onHover = _this$props3.onHover,
          hoverKey = _this$props3.hoverKey;

      onHover(true, hoverKey);
    }, _this.onMouseLeave = function () {
      var _this$props4 = _this.props,
          onHover = _this$props4.onHover,
          hoverKey = _this$props4.hoverKey;

      onHover(false, hoverKey);
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  TableRow.prototype.componentDidMount = function componentDidMount() {
    var _this2 = this;

    var _props = this.props,
        store = _props.store,
        hoverKey = _props.hoverKey;

    this.unsubscribe = store.subscribe(function () {
      if (store.getState().currentHoverKey === hoverKey) {
        _this2.setState({ hovered: true });
      } else if (_this2.state.hovered === true) {
        _this2.setState({ hovered: false });
      }
    });
  };

  TableRow.prototype.componentWillUnmount = function componentWillUnmount() {
    var _props2 = this.props,
        record = _props2.record,
        onDestroy = _props2.onDestroy,
        index = _props2.index;

    onDestroy(record, index);
    if (this.unsubscribe) {
      this.unsubscribe();
    }
  };

  TableRow.prototype.render = function render() {
    var _props3 = this.props,
        prefixCls = _props3.prefixCls,
        columns = _props3.columns,
        record = _props3.record,
        height = _props3.height,
        visible = _props3.visible,
        index = _props3.index,
        expandIconColumnIndex = _props3.expandIconColumnIndex,
        expandIconAsCell = _props3.expandIconAsCell,
        expanded = _props3.expanded,
        expandRowByClick = _props3.expandRowByClick,
        expandable = _props3.expandable,
        onExpand = _props3.onExpand,
        needIndentSpaced = _props3.needIndentSpaced,
        indent = _props3.indent,
        indentSize = _props3.indentSize;
    var className = this.props.className;


    if (this.state.hovered) {
      className += ' ' + prefixCls + '-hover';
    }

    var cells = [];

    var expandIcon = _react2["default"].createElement(_ExpandIcon2["default"], {
      expandable: expandable,
      prefixCls: prefixCls,
      onExpand: onExpand,
      needIndentSpaced: needIndentSpaced,
      expanded: expanded,
      record: record
    });

    for (var i = 0; i < columns.length; i++) {
      if (expandIconAsCell && i === 0) {
        cells.push(_react2["default"].createElement(
          'td',
          {
            className: prefixCls + '-expand-icon-cell',
            key: 'rc-table-expand-icon-cell'
          },
          expandIcon
        ));
      }
      var isColumnHaveExpandIcon = expandIconAsCell || expandRowByClick ? false : i === expandIconColumnIndex;
      cells.push(_react2["default"].createElement(_TableCell2["default"], {
        prefixCls: prefixCls,
        record: record,
        indentSize: indentSize,
        indent: indent,
        index: index,
        column: columns[i],
        key: columns[i].key,
        expandIcon: isColumnHaveExpandIcon ? expandIcon : null
      }));
    }
    var style = { height: height };
    if (!visible) {
      style.display = 'none';
    }

    return _react2["default"].createElement(
      'tr',
      {
        onClick: this.onRowClick,
        onDoubleClick: this.onRowDoubleClick,
        onMouseEnter: this.onMouseEnter,
        onMouseLeave: this.onMouseLeave,
        className: prefixCls + ' ' + className + ' ' + prefixCls + '-level-' + indent,
        style: style
      },
      cells
    );
  };

  return TableRow;
}(_react2["default"].Component);

TableRow.propTypes = {
  onDestroy: _react.PropTypes.func,
  onRowClick: _react.PropTypes.func,
  onRowDoubleClick: _react.PropTypes.func,
  record: _react.PropTypes.object,
  prefixCls: _react.PropTypes.string,
  expandIconColumnIndex: _react.PropTypes.number,
  onHover: _react.PropTypes.func,
  columns: _react.PropTypes.array,
  height: _react.PropTypes.oneOfType([_react.PropTypes.string, _react.PropTypes.number]),
  visible: _react.PropTypes.bool,
  index: _react.PropTypes.number,
  hoverKey: _react.PropTypes.any,
  expanded: _react.PropTypes.bool,
  expandable: _react.PropTypes.any,
  onExpand: _react.PropTypes.func,
  needIndentSpaced: _react.PropTypes.bool,
  className: _react.PropTypes.string,
  indent: _react.PropTypes.number,
  indentSize: _react.PropTypes.number,
  expandIconAsCell: _react.PropTypes.bool,
  expandRowByClick: _react.PropTypes.bool,
  store: _react.PropTypes.object.isRequired
};
TableRow.defaultProps = {
  onRowClick: function onRowClick() {},
  onRowDoubleClick: function onRowDoubleClick() {},
  onDestroy: function onDestroy() {},

  expandIconColumnIndex: 0,
  expandRowByClick: false,
  onHover: function onHover() {}
};
exports["default"] = TableRow;
module.exports = exports['default'];