'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

exports["default"] = {
  propTypes: {
    prefixCls: _react.PropTypes.string,
    strokeWidth: _react.PropTypes.oneOfType([_react.PropTypes.number, _react.PropTypes.string]),
    strokeColor: _react.PropTypes.string,
    trailWidth: _react.PropTypes.oneOfType([_react.PropTypes.number, _react.PropTypes.string]),
    trailColor: _react.PropTypes.string,
    strokeLinecap: _react.PropTypes.oneOf(['round', 'square']),
    style: _react.PropTypes.object,
    className: _react.PropTypes.string
  },
  getDefaultProps: function getDefaultProps() {
    return {
      prefixCls: 'rc-progress',
      strokeWidth: 1,
      strokeColor: '#2db7f5',
      trailWidth: 1,
      trailColor: '#D9D9D9',
      strokeLinecap: 'round',
      className: ''
    };
  },
  componentDidUpdate: function componentDidUpdate() {
    var now = Date.now();
    this.path.style.transitionDuration = '0.3s, 0.3s';
    if (this.prevTimeStamp && now - this.prevTimeStamp < 100) {
      this.path.style.transitionDuration = '0s, 0s';
    }
    this.prevTimeStamp = Date.now();
  }
};
module.exports = exports['default'];