'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _immutable = require('immutable');

var offset = (0, _immutable.Map)(); /* eslint new-cap: [2, {capIsNewExceptions: ["Map"]}] */

var mentionStore = {
  offset: (0, _immutable.Map)(),
  getOffset: function getOffset() {
    return offset;
  },
  activeSuggestion: function activeSuggestion(_ref) {
    var offsetKey = _ref.offsetKey;

    offset = offset.set(offsetKey, {
      offsetKey: offsetKey
    });
  },
  inActiveSuggestion: function inActiveSuggestion(_ref2) {
    var offsetKey = _ref2.offsetKey;

    offset = offset["delete"](offsetKey);
  },
  updateSuggestion: function updateSuggestion(_ref3) {
    var offsetKey = _ref3.offsetKey,
        position = _ref3.position;

    offset = offset.set(offsetKey, {
      offsetKey: offsetKey,
      position: position
    });
  }
};

// function storeAction(state = defaultState, action) {
//   switch (action.type) {
//     case ACTIVE_SUGGESTION:
//       state.offset = state.offset.set(action.offsetKey, {
//         offsetKey: action.offsetKey,
//       });
//       break;
//     case INACTIVE_SUGGESTION:
//       state.offset = state.offset.delete(action.offsetKey);
//       break;
//     case UPDATE_SUGGESTION:
//       state.offset = state.offset.set(action.offsetKey, {
//         offsetKey: action.offsetKey,
//         position: action.position,
//       });
//       break;
//     default: break;
//   }
//   return state;
// }

// export default createStore(storeAction);
exports["default"] = mentionStore;
module.exports = exports['default'];