'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = getMentions;
function getMentions(editorState) {
  var prefix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '@';

  var escapedPrefix = prefix.replace(/(\$|\^)/g, '\\$1');
  var regex = new RegExp('(\\s|^)' + escapedPrefix + '[^\\s]*', 'g');
  var contentState = editorState.getCurrentContent();
  var entities = [];
  contentState.getBlockMap().forEach(function (block) {
    var blockText = block.getText();
    var matchArr = void 0;
    while ((matchArr = regex.exec(blockText)) !== null) {
      // eslint-disable-line
      entities.push(matchArr[0].trim());
    }
  });
  return entities;
}
module.exports = exports['default'];