'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports["default"] = createMention;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Suggestions2 = require('./Suggestions');

var _Suggestions3 = _interopRequireDefault(_Suggestions2);

var _SuggestionPortal = require('./SuggestionPortal');

var _SuggestionPortal2 = _interopRequireDefault(_SuggestionPortal);

var _MentionContent = require('./MentionContent');

var _MentionContent2 = _interopRequireDefault(_MentionContent);

var _mentionStore = require('./mentionStore');

var _mentionStore2 = _interopRequireDefault(_mentionStore);

var _exportContent = require('./exportContent');

var _exportContent2 = _interopRequireDefault(_exportContent);

var _draftJs = require('draft-js');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defaults(obj, defaults) { var keys = Object.getOwnPropertyNames(defaults); for (var i = 0; i < keys.length; i++) { var key = keys[i]; var value = Object.getOwnPropertyDescriptor(defaults, key); if (value && value.configurable && obj[key] === undefined) { Object.defineProperty(obj, key, value); } } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass); }

function findWithRegex(regex, contentBlock, callback) {
  // Get the text from the contentBlock
  var text = contentBlock.getText();
  var matchArr = void 0;
  var start = void 0; // eslint-disable-line
  // Go through all matches in the text and return the indizes to the callback
  while ((matchArr = regex.exec(text)) !== null) {
    // eslint-disable-line
    start = matchArr.index;
    callback(start, start + matchArr[0].length);
  }
}

function mentionContentStrategy(contentBlock, callback) {
  contentBlock.findEntityRanges(function (character) {
    var entityKey = character.getEntity();
    return entityKey && _draftJs.Entity.get(entityKey).getType() === 'mention';
  }, callback);
}

function noop() {}

var MentionContentComponent = function (_React$Component) {
  _inherits(MentionContentComponent, _React$Component);

  function MentionContentComponent() {
    _classCallCheck(this, MentionContentComponent);

    return _possibleConstructorReturn(this, _React$Component.apply(this, arguments));
  }

  MentionContentComponent.prototype.render = function render() {
    var _props = this.props,
        entityKey = _props.entityKey,
        tag = _props.tag;

    var data = _draftJs.Entity.get(entityKey).getData();
    return _react2["default"].createElement(tag, _extends({}, this.props, { data: data }));
  };

  return MentionContentComponent;
}(_react2["default"].Component);

MentionContentComponent.propTypes = {
  entityKey: _react2["default"].PropTypes.element,
  tag: _react2["default"].PropTypes.element
};
function createMention() {
  var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  var callbacks = {
    onChange: noop,
    onUpArrow: noop,
    onDownArrow: noop,
    getEditorState: noop,
    setEditorState: noop,
    handleReturn: noop,
    onBlur: noop
  };
  var componentProps = {
    callbacks: callbacks,
    mentionStore: _mentionStore2["default"]
  };
  var prefix = config.prefix.replace(/(\$|\^)/g, '\\$1');
  var suggestionRegex = new RegExp('(\\s|^)' + prefix + '[^\\s]*', 'g');

  var tag = config.tag || _MentionContent2["default"];
  var decorators = [{
    strategy: function strategy(contentBlock, callback) {
      findWithRegex(suggestionRegex, contentBlock, callback);
    },
    component: function component(props) {
      return _react2["default"].createElement(_SuggestionPortal2["default"], _extends({}, props, componentProps));
    }
  }];
  if (config.mode !== 'immutable') {
    decorators.unshift({
      strategy: mentionContentStrategy,
      component: function component(props) {
        return _react2["default"].createElement(MentionContentComponent, _extends({ tag: tag }, props));
      }
    });
  }

  return {
    name: 'mention',
    Suggestions: function Suggestions(props) {
      return _react2["default"].createElement(_Suggestions3["default"], _extends({}, props, componentProps, {
        store: _mentionStore2["default"]
      }));
    },
    decorators: decorators,
    onChange: function onChange(editorState) {
      return callbacks.onChange ? callbacks.onChange(editorState) : editorState;
    },
    callbacks: callbacks,
    "export": _exportContent2["default"]
  };
}
module.exports = exports['default'];