'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports["default"] = createImmutableMention;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _draftJs = require('draft-js');

var _MentionContent = require('../component/MentionContent.react');

var _MentionContent2 = _interopRequireDefault(_MentionContent);

var _Suggestions2 = require('../component/Suggestions.react');

var _Suggestions3 = _interopRequireDefault(_Suggestions2);

var _mentionStore = require('../model/mentionStore');

var _mentionStore2 = _interopRequireDefault(_mentionStore);

var _exportContent = require('../utils/exportContent');

var _exportContent2 = _interopRequireDefault(_exportContent);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defaults(obj, defaults) { var keys = Object.getOwnPropertyNames(defaults); for (var i = 0; i < keys.length; i++) { var key = keys[i]; var value = Object.getOwnPropertyDescriptor(defaults, key); if (value && value.configurable && obj[key] === undefined) { Object.defineProperty(obj, key, value); } } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass); }

function noop() {}

var MentionContentComponent = function (_React$Component) {
  _inherits(MentionContentComponent, _React$Component);

  function MentionContentComponent() {
    _classCallCheck(this, MentionContentComponent);

    return _possibleConstructorReturn(this, _React$Component.apply(this, arguments));
  }

  MentionContentComponent.prototype.render = function render() {
    var _props = this.props,
        entityKey = _props.entityKey,
        tag = _props.tag,
        callbacks = _props.callbacks;

    var contentState = callbacks.getEditorState().getCurrentContent();
    var data = contentState.getEntity(entityKey).getData();
    return _react2["default"].createElement(tag, _extends({}, this.props, { data: data }));
  };

  return MentionContentComponent;
}(_react2["default"].Component);

MentionContentComponent.propTypes = {
  entityKey: _react2["default"].PropTypes.element,
  callbacks: _react2["default"].PropTypes.func,
  tag: _react2["default"].PropTypes.element
};


function mentionContentStrategy(contentBlock, callback, contentState) {
  contentBlock.findEntityRanges(function (character) {
    var entityKey = character.getEntity();
    return entityKey && contentState.getEntity(entityKey).getType() === 'mention';
  }, callback);
}

function mentionTriggerStrategy(contentBlock, callback, contentState) {
  contentBlock.findEntityRanges(function (character) {
    var entityKey = character.getEntity();
    return entityKey && contentState.getEntity(entityKey).getType() === 'trigger';
  }, callback);
}

function createImmutableMention() {
  var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  var callbacks = {
    onChange: noop,
    onUpArrow: noop,
    onDownArrow: noop,
    getEditorState: noop,
    setEditorState: noop,
    handleReturn: noop,
    onBlur: noop
  };

  function _onChange(editorState) {
    var selectionState = editorState.getSelection();
    var currentContent = editorState.getCurrentContent();
    var anchorKey = selectionState.getAnchorKey();
    var currentContentBlock = currentContent.getBlockForKey(anchorKey);

    console.log('>> entity', currentContentBlock.getEntityAt(anchorKey));
    if (selectionState.isCollapsed()) {
      currentContent.createEntity('trigger', 'MUTABLE');

      var end = selectionState.getEndOffset();
      var start = end - 1;
      var selectedText = currentContentBlock.getText().slice(start, end);
      if (selectedText === '@') {
        var updatedContent = _draftJs.Modifier.replaceText(currentContent, selectionState.merge({
          anchorOffset: start,
          focusOffset: end
        }), '@', null, currentContent.getLastCreatedEntityKey());
        return _draftJs.EditorState.push(editorState, updatedContent, 'insert-mention');
      }
    }

    return editorState;
  }

  var componentProps = {
    callbacks: callbacks,
    mentionStore: _mentionStore2["default"]
  };
  return {
    name: 'mention',
    Suggestions: function Suggestions(props) {
      return _react2["default"].createElement(_Suggestions3["default"], _extends({}, props, componentProps, {
        store: _mentionStore2["default"]
      }));
    },
    decorators: [{
      strategy: mentionTriggerStrategy,
      component: function component(props) {
        return _react2["default"].createElement('span', _extends({}, props, { style: { color: 'red' } }));
      }
    }, {
      strategy: mentionContentStrategy,
      component: function component(props) {
        return _react2["default"].createElement(MentionContentComponent, _extends({ tag: tag }, props, { callbacks: callbacks }));
      }
    }],
    onChange: function onChange(editorState) {
      var updatedEditorState = _onChange(editorState);
      return callbacks.onChange ? callbacks.onChange(updatedEditorState) : updatedEditorState;
    },
    callbacks: callbacks,
    "export": _exportContent2["default"]
  };
}
module.exports = exports['default'];