'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _DraftOffsetKey = require('draft-js/lib/DraftOffsetKey');

var _rcAnimate = require('rc-animate');

var _rcAnimate2 = _interopRequireDefault(_rcAnimate);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _domScrollIntoView = require('dom-scroll-into-view');

var _domScrollIntoView2 = _interopRequireDefault(_domScrollIntoView);

var _Nav = require('./Nav.react');

var _Nav2 = _interopRequireDefault(_Nav);

var _SuggestionWrapper = require('./SuggestionWrapper.react');

var _SuggestionWrapper2 = _interopRequireDefault(_SuggestionWrapper);

var _insertMention = require('../utils/insertMention');

var _insertMention2 = _interopRequireDefault(_insertMention);

var _clearMention = require('../utils/clearMention');

var _clearMention2 = _interopRequireDefault(_clearMention);

var _getOffset = require('../utils/getOffset');

var _getOffset2 = _interopRequireDefault(_getOffset);

var _getMentions = require('../utils/getMentions');

var _getMentions2 = _interopRequireDefault(_getMentions);

var _getSearchWord2 = require('../utils/getSearchWord');

var _getSearchWord3 = _interopRequireDefault(_getSearchWord2);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defaults(obj, defaults) { var keys = Object.getOwnPropertyNames(defaults); for (var i = 0; i < keys.length; i++) { var key = keys[i]; var value = Object.getOwnPropertyDescriptor(defaults, key); if (value && value.configurable && obj[key] === undefined) { Object.defineProperty(obj, key, value); } } return obj; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass); }

var isNotFalse = function isNotFalse(i) {
  return i !== false;
};

var Suggestions = function (_React$Component) {
  _inherits(Suggestions, _React$Component);

  function Suggestions() {
    _classCallCheck(this, Suggestions);

    var _this = _possibleConstructorReturn(this, _React$Component.call(this));

    _this.onEditorStateChange = function (editorState) {
      var offset = _this.props.store.getOffset();
      if (offset.size === 0) {
        return editorState;
      }
      var selection = editorState.getSelection();
      // 修复: 焦点移出再移入时, dropdown 会闪动一下
      // 原因: https://github.com/facebook/draft-js/blob/67c5e69499e3b0c149ce83b004872afdf4180463/src/component/handlers/edit/editOnFocus.js#L33
      // 此处强制 update 了一下,因此 onEditorStateChange 会 call 两次
      if (!_this.props.callbacks.getEditorState().getSelection().getHasFocus() && selection.getHasFocus()) {
        return editorState;
      }

      var _getSearchWord = (0, _getSearchWord3["default"])(editorState, selection),
          word = _getSearchWord.word;

      var selectionInsideMention = offset.map(function (_ref) {
        var offsetKey = _ref.offsetKey;

        var _decode = (0, _DraftOffsetKey.decode)(offsetKey),
            blockKey = _decode.blockKey,
            decoratorKey = _decode.decoratorKey,
            leafKey = _decode.leafKey;

        if (blockKey !== selection.anchorKey) {
          return false;
        }
        var leaf = editorState.getBlockTree(blockKey).getIn([decoratorKey, 'leaves', leafKey]);
        if (!leaf) {
          return false;
        }
        var startKey = leaf.get('start');
        var endKey = leaf.get('end');
        // 处理只有一个 `@` 符号时的情况
        if (!word) {
          return false;
        }
        if (startKey === endKey - 1) {
          return selection.anchorOffset >= startKey + 1 && selection.anchorOffset <= endKey ? offsetKey : false;
        }
        return selection.anchorOffset > startKey + 1 && selection.anchorOffset <= endKey ? offsetKey : false;
      });

      var selectionInText = selectionInsideMention.some(isNotFalse);
      _this.activeOffsetKey = selectionInsideMention.find(isNotFalse);
      var trigger = _this.props.store.getTrigger(_this.activeOffsetKey);

      if (!selectionInText || !selection.getHasFocus()) {
        _this.closeDropDown();
        return editorState;
      }
      console.log('>> trigger', trigger);
      var searchValue = word.substring(trigger.length, word.length);
      if (_this.lastSearchValue !== searchValue || _this.lastTrigger !== trigger) {
        _this.lastSearchValue = searchValue;
        _this.lastTrigger = trigger;
        _this.props.onSearchChange(searchValue, trigger);
      }
      if (!_this.state.active) {
        _this.openDropDown();
      }
      return editorState;
    };

    _this.onUpArrow = function (ev) {
      ev.preventDefault();
      if (_this.props.suggestions.length > 0) {
        var newIndex = _this.state.focusedIndex - 1;
        _this.setState({
          focusedIndex: Math.max(newIndex, 0)
        });
      }
    };

    _this.onBlur = function (ev) {
      ev.preventDefault();
      _this.closeDropDown();
    };

    _this.onDownArrow = function (ev) {
      ev.preventDefault();
      var newIndex = _this.state.focusedIndex + 1;
      _this.setState({
        focusedIndex: newIndex >= _this.props.suggestions.length ? 0 : newIndex
      });
    };

    _this.getContainer = function () {
      var popupContainer = document.createElement('div');
      var mountNode = void 0;
      if (_this.props.getSuggestionContainer) {
        mountNode = _this.props.getSuggestionContainer();
        popupContainer.style.position = 'relative';
      } else {
        mountNode = document.body;
      }
      mountNode.appendChild(popupContainer);
      return popupContainer;
    };

    _this.handleKeyBinding = function (command) {
      return command === 'split-block';
    };

    _this.handleReturn = function (ev) {
      ev.preventDefault();
      var selectedSuggestion = _this.props.suggestions[_this.state.focusedIndex];
      if (selectedSuggestion) {
        if (_react2["default"].isValidElement(selectedSuggestion)) {
          _this.onMentionSelect(selectedSuggestion.props.value, selectedSuggestion.props.data);
        } else {
          _this.onMentionSelect(selectedSuggestion);
        }
        _this.lastSearchValue = null;
        _this.lastTrigger = null;
        return true;
      }
      return false;
    };

    _this.renderReady = function () {
      var focusItem = _reactDom2["default"].findDOMNode(_this.refs.focusItem);
      var container = _this.refs.dropdownContainer;
      if (!container) {
        return;
      }
      var active = _this.state.active;
      var activeOffsetKey = _this.activeOffsetKey;

      var offset = _this.props.store.getOffset();
      var dropDownPosition = offset.get(activeOffsetKey);
      if (active && dropDownPosition) {
        (function () {
          var dropDownStyle = _this.getPositionStyle(true, dropDownPosition.position());
          Object.keys(dropDownStyle).forEach(function (key) {
            container.style[key] = dropDownStyle[key];
          });
        })();
      }

      if (!focusItem) {
        return;
      }
      (0, _domScrollIntoView2["default"])(focusItem, container, {
        onlyScrollIfNeeded: true
      });
    };

    _this.getNavigations = function () {
      var _this$props = _this.props,
          prefixCls = _this$props.prefixCls,
          suggestions = _this$props.suggestions;
      var focusedIndex = _this.state.focusedIndex;

      return suggestions.length ? _react2["default"].Children.map(suggestions, function (element, index) {
        var focusItem = index === focusedIndex;
        var ref = focusItem ? 'focusItem' : null;
        var mentionClass = (0, _classnames2["default"])(prefixCls + '-dropdown-item', {
          focus: focusItem
        });
        if (_react2["default"].isValidElement(element)) {
          return _react2["default"].cloneElement(element, {
            className: mentionClass,
            onMouseDown: _this.onMentionSelect.bind(_this, element.props.value, element.props.data),
            ref: ref
          });
        }
        return _react2["default"].createElement(
          _Nav2["default"],
          { ref: ref,
            className: mentionClass,
            onMouseDown: _this.onMentionSelect.bind(_this, element)
          },
          element
        );
      }, _this) : _react2["default"].createElement(
        'div',
        { className: prefixCls + '-dropdown-notfound ' + prefixCls + '-dropdown-item' },
        _this.props.notFoundContent
      );
    };

    _this.state = {
      isActive: false,
      focusedIndex: 0,
      container: false
    };
    return _this;
  }

  Suggestions.prototype.componentDidMount = function componentDidMount() {
    this.props.callbacks.onChange = this.onEditorStateChange;
  };

  Suggestions.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    if (nextProps.suggestions.length !== this.props.suggestions.length) {
      this.setState({
        focusedIndex: 0
      });
    }
  };

  Suggestions.prototype.onMentionSelect = function onMentionSelect(mention, data) {
    var editorState = this.props.callbacks.getEditorState();
    var _props = this.props,
        store = _props.store,
        onSelect = _props.onSelect;

    var trigger = store.getTrigger(this.activeOffsetKey);
    if (onSelect) {
      onSelect(mention, data || mention);
    }
    if (this.props.noRedup) {
      var mentions = (0, _getMentions2["default"])(editorState, trigger);
      if (mentions.indexOf('' + trigger + mention) !== -1) {
        console.warn('you have specified `noRedup` props but have duplicated mentions.');
        this.closeDropDown();
        this.props.callbacks.setEditorState((0, _clearMention2["default"])(editorState));
        return;
      }
    }
    this.props.callbacks.setEditorState((0, _insertMention2["default"])(editorState, '' + trigger + mention, data, this.props.mode), true);
    this.closeDropDown();
  };

  Suggestions.prototype.getPositionStyle = function getPositionStyle(isActive, position) {
    if (this.props.getSuggestionStyle) {
      return this.props.getSuggestionStyle(isActive, position);
    }
    var container = this.props.getSuggestionContainer ? this.state.container : document.body;
    var offset = (0, _getOffset2["default"])(container);
    return position ? _extends({
      position: 'absolute',
      left: position.left - offset.left + 'px',
      top: position.top - offset.top + 'px'
    }, this.props.style) : {};
  };

  Suggestions.prototype.openDropDown = function openDropDown() {
    this.props.callbacks.onUpArrow = this.onUpArrow;
    this.props.callbacks.handleReturn = this.handleReturn;
    this.props.callbacks.handleKeyBinding = this.handleKeyBinding;
    this.props.callbacks.onDownArrow = this.onDownArrow;
    this.props.callbacks.onBlur = this.onBlur;
    this.setState({
      active: true,
      container: this.state.container || this.getContainer()
    });
  };

  Suggestions.prototype.closeDropDown = function closeDropDown() {
    this.props.callbacks.onUpArrow = null;
    this.props.callbacks.handleReturn = null;
    this.props.callbacks.handleKeyBinding = null;
    this.props.callbacks.onDownArrow = null;
    this.props.callbacks.onBlur = null;
    this.setState({
      active: false
    });
  };

  Suggestions.prototype.render = function render() {
    var _props2 = this.props,
        prefixCls = _props2.prefixCls,
        suggestions = _props2.suggestions,
        className = _props2.className;
    var container = this.state.container;

    var cls = (0, _classnames2["default"])(_extends(_defineProperty({}, prefixCls + '-dropdown', true), className));

    var navigations = this.getNavigations();

    return container ? _react2["default"].createElement(
      _SuggestionWrapper2["default"],
      { renderReady: this.renderReady, container: container },
      _react2["default"].createElement(
        _rcAnimate2["default"],
        {
          transitionName: 'slide-up'
        },
        this.state.active ? _react2["default"].createElement(
          'div',
          { className: cls, ref: 'dropdownContainer' },
          navigations
        ) : null
      )
    ) : null;
  };

  return Suggestions;
}(_react2["default"].Component);

exports["default"] = Suggestions;


Suggestions.propTypes = {
  callbacks: _react2["default"].PropTypes.object,
  suggestions: _react2["default"].PropTypes.array,
  store: _react2["default"].PropTypes.object,
  onSearchChange: _react2["default"].PropTypes.func,
  prefix: _react2["default"].PropTypes.oneOfType([_react2["default"].PropTypes.string, _react2["default"].PropTypes.arrayOf(_react2["default"].PropTypes.string)]),
  prefixCls: _react2["default"].PropTypes.string,
  mode: _react2["default"].PropTypes.string,
  style: _react2["default"].PropTypes.object,
  onSelect: _react2["default"].PropTypes.func,
  getSuggestionContainer: _react2["default"].PropTypes.func,
  notFoundContent: _react2["default"].PropTypes.any,
  getSuggestionStyle: _react2["default"].PropTypes.func,
  className: _react2["default"].PropTypes.string,
  noRedup: _react2["default"].PropTypes.bool
};
module.exports = exports['default'];