'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _react = require('react');

var React = _interopRequireWildcard(_react);

var _immutable = require('immutable');

var _ToolbarLine = require('./ToolbarLine');

var _ToolbarLine2 = _interopRequireDefault(_ToolbarLine);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) newObj[key] = obj[key]; } } newObj["default"] = obj; return newObj; } }

function _defaults(obj, defaults) { var keys = Object.getOwnPropertyNames(defaults); for (var i = 0; i < keys.length; i++) { var key = keys[i]; var value = Object.getOwnPropertyDescriptor(defaults, key); if (value && value.configurable && obj[key] === undefined) { Object.defineProperty(obj, key, value); } } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass); }

function noop() {}

var Toolbar = function (_React$Component) {
    _inherits(Toolbar, _React$Component);

    function Toolbar(props) {
        _classCallCheck(this, Toolbar);

        var _this = _possibleConstructorReturn(this, _React$Component.call(this, props));

        var map = {};
        props.plugins.forEach(function (plugin) {
            map[plugin.name] = plugin;
        });
        _this.pluginsMap = (0, _immutable.Map)(map);
        _this.state = {
            editorState: props.editorState,
            toolbars: []
        };
        return _this;
    }

    Toolbar.prototype.renderToolbarItem = function renderToolbarItem(pluginName, idx) {
        var element = this.pluginsMap.get(pluginName);
        if (element && element.component) {
            var component = element.component;

            var props = {
                key: 'toolbar-item-' + idx,
                onClick: component.props ? component.props.onClick : noop
            };
            if (React.isValidElement(component)) {
                return React.cloneElement(component, props);
            }
            return React.createElement(component, props);
        }
        return null;
    };

    Toolbar.prototype.conpomentWillReceiveProps = function conpomentWillReceiveProps(nextProps) {
        this.render();
    };

    Toolbar.prototype.render = function render() {
        var _this2 = this;

        var _props = this.props,
            toolbars = _props.toolbars,
            prefixCls = _props.prefixCls;

        return React.createElement("div", { className: prefixCls + '-toolbar' }, toolbars.map(function (toolbar, idx) {
            var children = React.Children.map(toolbar, _this2.renderToolbarItem.bind(_this2));
            return React.createElement(_ToolbarLine2["default"], { key: 'toolbar-' + idx }, children);
        }));
    };

    return Toolbar;
}(React.Component);

exports["default"] = Toolbar;
module.exports = exports['default'];