'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports["default"] = customHTML2Content;

var _draftJs = require('draft-js');

var _lodash = require('lodash');

var _immutable = require('immutable');

function compose() {
    for (var _len = arguments.length, argument = Array(_len), _key = 0; _key < _len; _key++) {
        argument[_key] = arguments[_key];
    }

    var args = arguments;
    var start = args.length - 1;
    return function () {
        var i = start;
        var result = args[start].apply(this, arguments);
        while (i--) {
            result = args[i].call(this, result);
        }return result;
    };
}
;
var getBlockSpecForElement = function getBlockSpecForElement(imgElement) {
    return {
        contentType: 'image',
        src: imgElement.getAttribute('src'),
        width: imgElement.getAttribute('width'),
        height: imgElement.getAttribute('height'),
        align: imgElement.style.cssFloat
    };
};
var wrapBlockSpec = function wrapBlockSpec(blockSpec) {
    if (blockSpec == null) {
        return null;
    }
    var tempEl = document.createElement('blockquote');
    tempEl.innerText = JSON.stringify(blockSpec);
    return tempEl;
};
var replaceElement = function replaceElement(oldEl, newEl) {
    if (!(newEl instanceof HTMLElement)) {
        return;
    }
    var parentNode = oldEl.parentNode;
    return parentNode.replaceChild(newEl, oldEl);
};
var elementToBlockSpecElement = compose(wrapBlockSpec, getBlockSpecForElement);
var imgReplacer = function imgReplacer(imgElement) {
    return replaceElement(imgElement, elementToBlockSpecElement(imgElement));
};
var createContentBlock = function createContentBlock(blockData, contentState) {
    var key = blockData.key,
        type = blockData.type,
        text = blockData.text,
        data = blockData.data,
        inlineStyles = blockData.inlineStyles,
        entityData = blockData.entityData;

    var blockSpec = {
        type: type != null ? type : 'unstyled',
        text: text != null ? text : '',
        key: key != null ? key : (0, _draftJs.genKey)(),
        data: null,
        characterList: (0, _immutable.List)([])
    };
    if (data) {
        blockSpec.data = (0, _immutable.fromJS)(data);
    }
    if (inlineStyles || entityData) {
        var entityKey = void 0;
        if (entityData) {
            var _type = entityData.type,
                mutability = entityData.mutability,
                _data = entityData.data;

            contentState.createEntity(_type, mutability, _data);
            entityKey = contentState.getLastCreatedEntityKey();
        } else {
            entityKey = null;
        }
        var style = (0, _immutable.OrderedSet)(inlineStyles || []);
        var charData = _draftJs.CharacterMetadata.create({ style: style, entityKey: entityKey });
        blockSpec.characterList = (0, _immutable.List)((0, _immutable.Repeat)(charData, text.length));
    }
    return new _draftJs.ContentBlock(blockSpec);
};
function customHTML2Content(HTML, contentState) {
    var tempDoc = new DOMParser().parseFromString(HTML, 'text/html');
    (0, _lodash.toArray)(tempDoc.querySelectorAll('img')).forEach(imgReplacer);

    var _convertFromHTML = (0, _draftJs.convertFromHTML)(tempDoc.body.innerHTML),
        contentBlocks = _convertFromHTML.contentBlocks;

    contentBlocks = contentBlocks.reduce(function (contentBlocks, block) {
        if (block.getType() !== 'blockquote') {
            return contentBlocks.concat(block);
        }
        var image = JSON.parse(block.getText());
        contentState.createEntity('IMAGE-ENTITY', 'IMMUTABLE', image);
        var entityKey = contentState.getLastCreatedEntityKey();
        var charData = _draftJs.CharacterMetadata.create({ entity: entityKey });
        var fragmentArray = [new _draftJs.ContentBlock({
            key: (0, _draftJs.genKey)(),
            type: 'image-block',
            text: ' ',
            characterList: (0, _immutable.List)((0, _immutable.Repeat)(charData, charData.count()))
        }), new _draftJs.ContentBlock({
            key: (0, _draftJs.genKey)(),
            type: 'unstyled',
            text: '',
            characterList: (0, _immutable.List)()
        })];
        return contentBlocks.concat(fragmentArray);
    }, []);
    tempDoc = null;
    return _draftJs.BlockMapBuilder.createFromArray(contentBlocks);
}
module.exports = exports['default'];