'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.scrollTo = exports.easeInOutCubic = exports.reqAnimFrame = undefined;

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

exports.getDefaultTarget = getDefaultTarget;
exports.getOffsetTop = getOffsetTop;

var _getScroll = require('../_util/getScroll');

var _getScroll2 = _interopRequireDefault(_getScroll);

var _getRequestAnimationFrame = require('../_util/getRequestAnimationFrame');

var _getRequestAnimationFrame2 = _interopRequireDefault(_getRequestAnimationFrame);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var reqAnimFrame = exports.reqAnimFrame = (0, _getRequestAnimationFrame2["default"])();
var easeInOutCubic = exports.easeInOutCubic = function easeInOutCubic(t, b, c, d) {
    var cc = c - b;
    t /= d / 2;
    if (t < 1) {
        return cc / 2 * t * t * t + b;
    }
    return cc / 2 * ((t -= 2) * t * t + 2) + b;
};
function getDefaultTarget() {
    return typeof window !== 'undefined' ? window : null;
}
function getOffsetTop(element) {
    if (!element) {
        return 0;
    }
    if (!element.getClientRects().length) {
        return 0;
    }
    var rect = element.getBoundingClientRect();
    if (rect.width || rect.height) {
        var doc = element.ownerDocument;
        var docElem = doc.documentElement;
        return rect.top - docElem.clientTop;
    }
    return rect.top;
}
function _scrollTo(href) {
    var offsetTop = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var target = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : getDefaultTarget;
    var callback = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : function () {};

    var scrollTop = (0, _getScroll2["default"])(target(), true);
    var targetElement = document.getElementById(href.substring(1));
    if (!targetElement) {
        return;
    }
    var eleOffsetTop = getOffsetTop(targetElement);
    var targetScrollTop = scrollTop + eleOffsetTop - offsetTop;
    var startTime = Date.now();
    var frameFunc = function frameFunc() {
        var timestamp = Date.now();
        var time = timestamp - startTime;
        window.scrollTo(window.pageXOffset, easeInOutCubic(time, scrollTop, targetScrollTop, 450));
        if (time < 450) {
            reqAnimFrame(frameFunc);
        } else {
            callback();
        }
    };
    reqAnimFrame(frameFunc);
    history.pushState(null, '', href);
}
exports.scrollTo = _scrollTo;

var AnchorHelper = function () {
    function AnchorHelper() {
        (0, _classCallCheck3["default"])(this, AnchorHelper);

        this.links = [];
        this.currentAnchor = null;
        this._activeAnchor = '';
    }

    AnchorHelper.prototype.addLink = function addLink(link) {
        if (this.links.indexOf(link) === -1) {
            this.links.push(link);
        }
    };

    AnchorHelper.prototype.getCurrentActiveAnchor = function getCurrentActiveAnchor() {
        return this.currentAnchor;
    };

    AnchorHelper.prototype.setActiveAnchor = function setActiveAnchor(component) {
        this.currentAnchor = component;
    };

    AnchorHelper.prototype.getCurrentAnchor = function getCurrentAnchor() {
        var offsetTop = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
        var bounds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 5;

        var activeAnchor = '';
        if (typeof document === 'undefined') {
            return activeAnchor;
        }
        var linksPositions = this.links.map(function (section) {
            var target = document.getElementById(section.substring(1));
            if (target && getOffsetTop(target) < offsetTop + bounds) {
                var top = getOffsetTop(target);
                if (top <= offsetTop + bounds) {
                    return {
                        section: section,
                        top: top,
                        bottom: top + target.clientHeight
                    };
                }
            }
            return null;
        }).filter(function (section) {
            return section !== null;
        });
        if (linksPositions.length) {
            var maxSection = linksPositions.reduce(function (prev, curr) {
                return curr.top > prev.top ? curr : prev;
            });
            return maxSection.section;
        }
        return '';
    };

    AnchorHelper.prototype.scrollTo = function scrollTo(href, offsetTop) {
        var target = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : getDefaultTarget;
        var callback = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : function () {};

        _scrollTo(href, offsetTop, target, callback);
    };

    return AnchorHelper;
}();

exports["default"] = AnchorHelper;