const types = require('../actions/actionTypes');
const Cookies = require('js-cookie');
const moment = require('moment');
const _ = require('lodash');

const defaultData = {
    status: 'pending', // waiting login,
    users:[],
    upstreams:[],
    upCount:0,
    userCount:0,
    count:{user:0,upstream:0},
    detail:{
        pagination:{ current:1,total:1,pageSize:3 },
        users:[],
        upstreams:[]
    },
    range:[moment().subtract(6,'days').format('YYYYMMDD'), moment().format('YYYYMMDD')]
};

module.exports = function login (state = defaultData, action) {
    switch (action.type) {
    case types.MAINDATA:
        return _.assign({}, state, {status: action.status,userCount:action.data.userCount,upCount:action.data.upCount, users: action.data.users,upstreams:action.data.upstreams,range: action.data.range});
    case types.COUNTDATA:
        return _.assign({}, state, {count:action.data});
    case types.DETAILDATA:
        return _.assign({}, state, {detail:action.data});
    default:
        return state;
    }
};

