const mongoose = require('mongoose');
const {ObjectId} = mongoose.SchemaTypes;

const schema = mongoose.Schema({
    category: {
        type: Array,
        default: []
    },
    userId: {
        type: ObjectId,
        ref: 'user',
        required: true
    },
    times: {
        type: Number,
        default: 0,
        required: true
    },
    used: {
        type: Number,
        default: 0,
        required: false
    },
    plugin: {
        type: String,
        required: false
    }
}, {
    timestamps: true
});

schema.index({userId: 1});
schema.index({times: 1});
schema.index({category: 1});
module.exports = mongoose.model('user-auto-auth', schema);
