const React = require('react');
const connect = require('react-redux').connect;
const actions = require('../js/actions');

import { Menu,Icon,Button,Layout,Breadcrumb}  from 'antd';
const SubMenu = Menu.SubMenu;
const MenuItemGroup = Menu.ItemGroup;
const ButtonGroup = Button.Group;
const { Header, Footer, Sider, Content } = Layout;

const mapLocations = ['/manage','/manage/statistics','/manage/setting']

class Main extends React.Component{
	constructor(props){
		super(props);
		this.map = ['数据统计','数据统计','配置']
		this.state = {
		    current: '0',
		    openKeys: [],
		    theme: 'dark'
		}
	}

	handleClick(e){
		//this.props.dispatch(actions.getMenu());
		location.href = mapLocations[ e.key ];
  	}

  	onOpenChange(openKeys){
  		this.setState({ openKeys: openKeys });
  	}

	componentWillMount(){
		if(this.props.login && this.props.login.status == 'logout') 
			location.href = '/'
		const { dispatch } = this.props;
	}

	render(){
		console.log(this.props.menu.currentPage);
		return (
			<Layout className="layout">
			    <Header>
			      <div className="logo" >
			      	<span>蜂巢</span>
			      </div>
			      <Menu
			        theme="dark"
			        mode="horizontal"
			        defaultSelectedKeys = {[ this.props.menu.currentPage ]}
			        onClick={ this.handleClick.bind(this) }
			        style={{ lineHeight: '64px' }}
			      >
			        <SubMenu title={<span>数据统计</span>}>
			            <Menu.Item key="0">基础数据</Menu.Item>
			            <Menu.Item key="1">详细数据</Menu.Item>
			        </SubMenu>
			        <Menu.Item key="2">配置</Menu.Item>
			      </Menu>
			    </Header>
			    <Content style={{ padding: '0 50px' }}>
			      <Breadcrumb style={{ margin: '12px 0' }}>
			        <Breadcrumb.Item>{ this.map[ this.props.menu.currentPage ]}</Breadcrumb.Item>
			        <Breadcrumb.Item>{ this.props.menu.currentPage == '0' ? '基础数据' : (this.props.menu.currentPage == '1' ? '详细数据' : "账户与配置" )}</Breadcrumb.Item>
			      </Breadcrumb>
			      <div style={{ background: '#fff', padding: 24, minHeight: 280 }}>{
			      	this.props.children
			      }</div>
			    </Content>
			    <Footer style={{ textAlign: 'center' }}>
			      fengchao.xiaoyun.com ©2017 Created by xiaoyun
			    </Footer>
			  </Layout>
		)
	}
}

function mapStateToProps (state) {
	return state;
}
module.exports = connect(mapStateToProps)(Main);