const React = require('react');
const connect = require('react-redux').connect;
const actions = require('../../js/actions');
const types = require('../../js/actions/actionTypes');
const moment = require('moment');
import json2xlsx from '../../js/json2xlsx';

import { Table, Spin, Button}  from 'antd';

class Detail extends React.Component{
	constructor(props){
		super(props);
		// this.state= { pagination : { current: 0,total: 0} };
	}

	componentDidMount (){
		let limit = 100;
		let skip = 0;
		//await this.props.dispatch({status:'pending',type:types.DETAILDATA});
		this.props.dispatch(actions.getDetailData({limit,skip}));
	}

	handleTableChange (pagination, filters, sorter) {
	    const pager = this.props.data.detail.pagination;
	    pager.current = pagination.current;
	    this.props.dispatch(actions.getDetailData({limit: 100,skip: parseInt(pager.current)-1 }));
  	}

  	exportData(){
		let pluginMap = {
			'publish-baijia':'百家助手',
			'publish-netease':'网易助手'
		}
		
		let users = this.props.data.detail ? this.props.data.detail.users : [];
		let upstreams = this.props.data.detail ? this.props.data.detail.upstreams : [];
		let auths = this.props.data.detail ? this.props.data.detail.auths : [];
		let unbindhistorys = this.props.data.detail ? this.props.data.detail.unbindhistorys : 0;

		let upMap = {};
		let authMap = {};
		let unbindhistorysMap = {};
		let data = [];
		for(let i = 0;i < upstreams.length; i++){
			let id = upstreams[i]['_id']['creater'];
			upMap[id] = upstreams[i]['count'];
		}
		for(let i = 0;i < auths.length; i++){
			let id = auths[i]['userId'];
			if(authMap[id]) authMap[id].push(auths[i]);
			else authMap[id] = [auths[i]];
		}
		for(let i = 0;i < unbindhistorys.length; i++){
			let id = unbindhistorys[i]['_id']['userId'];
			unbindhistorysMap[id] = unbindhistorys[i]['count'];
		}

		for(let i = 0;i < users.length; i++){
			let item = users[i];
			let charges = ['-'];
			if(authMap[item['_id']]) charges = authMap[ item['_id'] ].map( x => pluginMap[x.plugin] + ':' + x.times );
			data.push({
				'用户名' : item['username'] || '-',
				'手机号' : item['phone'] || '-',
				'账户数量' : upMap[ item['_id'] ] || 0,
				'解绑记录':unbindhistorysMap[item['_id']] || 0,
				'充值记录':charges.join(','),
				'注册时间' : moment(item['createdAt']).format('YYYY/MM/DD HH:mm:ss')
			})
		}
		json2xlsx(data,{sheetName:"详细数据", filename :'详细数据'+moment().format('YYYYMMDD')+'.xlsx'});
	}

	render(){
		let columns = [ 
		 {
		  	title: '用户',
		  	dataIndex: 'name',
		  	key: 'name',
		  	width: 100,
		  	render: text => <a href="#">{text}</a>,
		  },
		  {
		  	title: '电话',
		  	dataIndex: 'phone',
		  	key: 'phone',
		  	width: 100,
		  	render: text => <a href="#">{text}</a>,
		  },
		  {
		  	title: '账户数量',
		  	dataIndex: 'ups',
		  	key: 'ups',
		  	width: 100,
		  	render: text => <a href="#">{text}</a>,
		  },
		  {
		  	title: '解绑记录',
		  	dataIndex: 'upsunbind',
		  	key: 'upsunbind',
		  	width: 100,
		  	render: text => <a href="#">{text}</a>,
		  },
		  {
		  	title: '充值记录',
		  	dataIndex: 'charges',
		  	key: 'charges',
		  	width: 100,
		  	render: text => <a href="#">{text}</a>,
		  },
		  {
		  	title: '注册时间',
		  	dataIndex: 'date',
		  	key: 'date',
		  	width: 100,
		  	render: text => <a href="#">{text}</a>,
		  }
		];
		let pluginMap = {
			'publish-baijia':'百家助手',
			'publish-netease':'网易助手'
		}
		
		let users = this.props.data.detail ? this.props.data.detail.users : [];
		let upstreams = this.props.data.detail ? this.props.data.detail.upstreams : [];
		let auths = this.props.data.detail ? this.props.data.detail.auths : [];
		let unbindhistorys = this.props.data.detail ? this.props.data.detail.unbindhistorys : 0;

		let upMap = {};
		let authMap = {};
		let unbindhistorysMap = {};
		let data = [];
		for(let i = 0;i < upstreams.length; i++){
			let id = upstreams[i]['_id']['creater'];
			upMap[id] = upstreams[i]['count'];
		}
		for(let i = 0;i < auths.length; i++){
			let id = auths[i]['userId'];
			if(authMap[id]) authMap[id].push(auths[i]);
			else authMap[id] = [auths[i]];
		}
		for(let i = 0;i < unbindhistorys.length; i++){
			let id = unbindhistorys[i]['_id']['userId'];
			unbindhistorysMap[id] = unbindhistorys[i]['count'];
		}

		for(let i = 0;i < users.length; i++){
			let item = users[i];
			let charges = ['-'];
			if(authMap[item['_id']]) charges = authMap[ item['_id'] ].map( x => pluginMap[x.plugin] + ':' + x.times );
			data.push({
				key : i,
				name : item['username'] || '-',
				phone : item['phone'] || '-',
				ups : upMap[ item['_id'] ] || 0,
				upsunbind:unbindhistorysMap[item['_id']] || 0,
				charges:charges.join(','),
				date : moment(item['createdAt']).format('YYYY/MM/DD HH:mm:ss')
			})
		}
		return (
			<Spin spinning= { this.props.data.status == 'pending' }>
				<Button type="primary" icon="poweroff"  onClick={ this.exportData.bind(this) } style={{margin:'10px 0px'}}>
          			导出数据
        		</Button>
				<Table columns={columns} dataSource = { data }  pagination={ this.props.data.detail.pagination }  size="middle" onChange = { this.handleTableChange.bind(this) } bordered/>
			</Spin>	
			)
	}
}

function mapStateToProps (state) {
	return state;
}
module.exports = connect(mapStateToProps)(Detail);