const minstache = require('minstache')

exports.execute = minstache.compile(`new Promise(resolve => {
    var window = __avatar__.currentWindow;
    var document = __avatar__.currentDocument;
    var fn = ({{!src}});
    var args = [];
    {{#args}}args.push({{!argument}});{{/args}}
    if(fn.length - 1 === args.length) {
        args.push((err, result) => resolve({err, result}));
        return fn.apply(null, args);
    }
    let response
    try {
        response = fn.apply(null, args);
    } catch (err) {
        const json = {message: err.message, stack: err.stack};
        return resolve({err: json})
    }
    if(response && response.then) {
        return response.then(result => {
            resolve({result});
        }, err => {
            const json = {message: err.message, stack: err.stack};
            resolve({err: json});
        })
    }
    resolve({result: response});
})`);

exports.inject = minstache.compile(`new Promise(resolve => {
    try {
        const response = {{!src}}
        if(response && response.then) {
            return response.then(result => {
                resolve({result});
            }, err => {
                const json = {message: err.message, stack: err.stack};
                resolve({err: json});
            })
        }
        resolve({result: response});
    } catch (err) {
        const json = {message: err.message, stack: err.stack};
        resolve({err: json});
    }
})`);
