const sliced = require('sliced');
const jsesc = require('jsesc');
const fs = require('fs');
const once = require('once');
const createDebug = require('debug');

const debug = createDebug('avatar:action')

const waitms = function (ms, done) {
    setTimeout(done, ms);
};

const waitfn = function () {
    var softTimeout = this.timeout || null;
    var executionTimer;
    var softTimeoutTimer;
    var runnerTimeoutTimer;
    var self = arguments[0];

    var args = sliced(arguments);
    var done = args[args.length - 1];

    var timeoutTimer = setTimeout(function () {
        clearTimeout(executionTimer);
        clearTimeout(softTimeoutTimer);
        clearTimeout(runnerTimeoutTimer);
        done(new Error(`.wait() timed out after ${self.options.waitTimeout}msec`));
    }, self.options.waitTimeout);
    return tick.apply(this, arguments);

    function tick (self, fn/** , arg1, arg2..., done**/) {
        if (softTimeout) {
            softTimeoutTimer = setTimeout(function () {
                clearTimeout(runnerTimeoutTimer);
                clearTimeout(executionTimer);
                clearTimeout(timeoutTimer);
                done();
            }, softTimeout);
        }

        let waitDone = function (err, result) {
            if (result) {
                clearTimeout(timeoutTimer);
                clearTimeout(softTimeoutTimer);
                clearTimeout(runnerTimeoutTimer);
                return done();
            } else if (err) {
                clearTimeout(timeoutTimer);
                clearTimeout(softTimeoutTimer);
                clearTimeout(runnerTimeoutTimer);
                return done(err);
            } else {
                executionTimer = setTimeout(function () {
                    clearTimeout(runnerTimeoutTimer);
                    tick.apply(self, args);
                }, self.options.pollInterval);
            }
        };
        let newArgs = [fn, waitDone].concat(args.slice(2, -1));
        runnerTimeoutTimer = setTimeout(() => {
            clearTimeout(executionTimer);
            tick.apply(self, args);
        }, self.options.pollInterval * 3);
        try {
            self.evaluateNow.apply(self, newArgs);
        } catch (err) {
            waitDone(err)
        }
    }
};

const waitelem = function (self, selector, done) {
    var elementPresent;
    eval('elementPresent = function() {' + // eslint-disable-line
    "  var element = document && document.body && document.querySelector('" + jsesc(selector) + "');" +
    '  return (element ? true : false);' +
    '};');
    waitfn.apply(this, [self, elementPresent, done]);
};

const focusSelector = function (done, selector) {
    return this.evaluateNow(function (selector) {
        document.querySelector(selector).focus();
    }, done.bind(this), selector);
};

const blurSelector = function (done, selector) {
    return this.evaluateNow(function (selector) {
        // it is possible the element has been removed from the DOM
        // between the action and the call to blur the element
        var element = document.querySelector(selector);
        if (element) {
            element.blur();
        }
    }, done.bind(this), selector);
};

exports.enterIframe = function (selector, done) {
    debug(`.enterIframe() ${selector}`);
    this.evaluateNow(selector => {
        const element = document.querySelector(selector);
        __avatar__.currentDocument = element.contentDocument; // eslint-disable-line
        __avatar__.currentWindow = element.contentWindow; // eslint-disable-line
    }, done, selector);
};

exports.exitIframe = function (done) {
    debug('.exitIframe()');
    this.evaluateNow(() => {
        __avatar__.currentDocument = __avatar__.currentWindow.parent.document; // eslint-disable-line
        __avatar__.currentWindow = __avatar__.currentWindow.parent; // eslint-disable-line
    }, done);
};

exports.waitIframe = function (selector, done) {
    debug(`.waitIframe() ${selector}`);
    this.evaluateNow((selector, pollInterval, done) => {
        const element = document.querySelector(selector);
        if (!element) {
            throw new Error('Unable to find element by selector: ' + selector);
        }
        function check () {
            if (element.contentDocument && element.contentDocument.readyState === 'complete') {
                return done();
            } else {
                setTimeout(() => check(), pollInterval)
            }
        }
        check()
    }, done, selector, this.options.pollInterval)
};

exports.or = function (options, action, done) {
    debug('.or()');
    if (arguments.length === 2) {
        done = action;
        action = null;
    }
    done = once(done);
    Object.keys(options)
        .forEach((key) =>
            options[key]().then(() => done(null, key)));
    action && action();
};

exports.redirect = function (done) {
    debug('.redirect()');
    this.once('did-get-redirect-request', (event) => {
        if (event.isMainFrame) {
            done();
        }
    });
};

exports.waitUrl = function (url, done) {
    const {webview} = this;
    function cleanup (error, data) {
        webview.removeEventListener('dom-ready', didDomReady);
        setImmediate(() => done(error, data));
    }
    function didDomReady () {
        const currentUrl = webview.getURL();
        if (typeof url === 'string' ? currentUrl === url : url(currentUrl)) {
            cleanup();
        }
    }
    webview.addEventListener('dom-ready', didDomReady);
};

exports.goto = function (url, headers, done) {
    debug(`.goto() url`);
    if (arguments.length === 2) {
        done = headers;
        headers = {};
    }
    headers = Object.assign({}, this._headers, headers);
    const {webview} = this;
    const {gotoTimeout: timeout} = this.options;

    if (!url || typeof url !== 'string') {
        return done('goto: `url` must be a non-empty string');
    }

    let httpReferrer = '';
    let extraHeaders = '';
    for (let key in headers) {
        if (key.toLowerCase() === 'referer') {
            httpReferrer = headers[key];
            continue;
        }
        extraHeaders += key + ': ' + headers[key] + '\n';
    }
    const loadUrlOptions = {extraHeaders: extraHeaders};
    httpReferrer && (loadUrlOptions.httpReferrer = httpReferrer);

    if (webview.getURL() === url) {
        return done();
    }

    const timer = setTimeout(() => {
        cleanup(new Error(`Navigation timed out after ${timeout} ms`));
    }, timeout);

    startLoading();

    function didDomReady () {
        cleanup();
    }

    function cleanup (error, data) {
        clearTimeout(timer);
        webview.removeEventListener('dom-ready', didDomReady);
        setImmediate(() => done(error, data));
    }

    function startLoading () {
        if (webview.isLoading()) {
            const didStopLoading = () => {
                webview.removeEventListener('did-stop-loading', didStopLoading);
                startLoading();
            };
            webview.addEventListener('did-stop-loading', didStopLoading);
            return webview.stop();
        }
        webview.addEventListener('dom-ready', didDomReady);
        webview.loadURL(url, loadUrlOptions);
    }
};

exports.appendTo = function (container, done) {
    debug('.appendTo()');
    const {webview} = this;
    if (webview.parentElement === container) {
        return done();
    }
    const _ready = new Promise(resolve => {
        const didDomReady = () => {
            webview.removeEventListener('dom-ready', didDomReady);
            resolve();
        };
        webview.addEventListener('dom-ready', didDomReady);
        container.appendChild(webview);
    });
    _ready.then(() => done());
    this._ready = this._ready.then(() => _ready);
};

exports.debugger = function (done) {
    debug('.debugger()');
    const {webview, _debugger} = this;
    if (_debugger) return done(null, _debugger);
    const webContents = webview.getWebContents();
    if (!webContents.debugger.isAttached()) {
        try {
            webContents.debugger.attach('1.1');
        } catch (error) {
            return done(error);
        }
    } else {
        debug('debugger is attached');
    }
    this._debugger = webContents.debugger;
    done(null, this._debugger);
};

exports.reject = function (filter, done) {
    const {webview} = this;
    const webContents = webview.getWebContents();
    webContents.session.webRequest.onBeforeSendHeaders(filter, (details, callback) => {
        callback({cancel: true});
    });
    done();
};

exports.response = function (url, optFn, done) {
    debug('.response()');
    if (arguments.length === 2) {
        done = optFn;
        optFn = null;
    }
    this.debugger()
        .then(_debugger => {
            const timeout = this.options.waitTimeout;
            const timer = setTimeout(() => {
                cleanup(new Error(`Response timed out after ${timeout} ms`));
            }, timeout);
            function onMessage (event, method, {response, requestId, type}) {
                debug(`network message: ${event} ${method} ${type} ${response && response.url}`);
                if (method === 'Network.responseReceived' && type === 'XHR') {
                    if (typeof url === 'string' ? response.url !== url : !url(response.url, response)) return;
                    _debugger.sendCommand('Network.getResponseBody', {requestId}, (err, res) => {
                        if (err && Object.keys(err).length) return cleanup(err);
                        if (optFn) {
                            optFn(res) && cleanup(null, res);
                        } else {
                            cleanup(null, res);
                        }
                    });
                }
            }
            function cleanup (err, result) {
                clearTimeout(timer);
                _debugger.sendCommand('Network.disable');
                _debugger.removeListener('message', onMessage);
                if (err) return done(err);
                done(null, result);
            }
            _debugger.on('message', onMessage);
            _debugger.sendCommand('Network.enable');
        });
};

exports.json = function (url, done) {
    debug(`.json() ${url}`);
    this.evaluateNow(function (url) {
        return fetch(url, { credentials: 'include' }) // eslint-disable-line
            .then(res => res.json());
    }, done, url);
};

exports.dev = function (done) {
    debug('.dev()');
    this.webview.openDevTools();
    done();
};

exports.title = function (done) {
    debug('.title()');
    this.evaluateNow(function () {
        return document.title;
    }, done);
};

exports.url = function (done) {
    debug('.url()');
    this.evaluateNow(function () {
        return document.location.href;
    }, done);
};

exports.path = function (done) {
    debug('.path()');
    this.evaluateNow(function () {
        return document.location.pathname;
    }, done);
};

exports.href = function (selector, done) {
    debug('.href()');
    this.evaluateNow(function (selector) {
        var elem = document.querySelector(selector);
        if (!elem) {
            throw new Error('Unable to find element by selector: ' + selector);
        }
        return elem.href;
    }, done, selector);
};

exports.text = function (selector, done) {
    debug(`.text() ${selector}`);
    this.evaluateNow(function (selector) {
        var elem = document.querySelector(selector);
        if (elem && elem.innerText) {
            return elem.innerText.trim();
        }
        return '';
    }, done, selector);
};

exports.visible = function (selector, done) {
    debug(`.visible() ${selector}`);
    this.evaluateNow(function (selector) {
        var elem = document.querySelector(selector);
        if (elem) return (elem.offsetWidth > 0 && elem.offsetHeight > 0);
        else return false;
    }, done, selector);
};

exports.exists = function (selector, done) {
    debug(`.exists() ${selector}`);
    this.evaluateNow(function (selector) {
        return (document.querySelector(selector) !== null);
    }, done, selector);
};

exports.click = function (selector, done) {
    debug(`.click() ${selector}`);
    this.evaluateNow(function (selector) {
        document.activeElement.blur();
        var element = document.querySelector(selector);
        if (!element) {
            throw new Error('Unable to find element by selector: ' + selector);
        }
        var event = document.createEvent('MouseEvent');
        event.initEvent('click', true, true);
        element.dispatchEvent(event);
    }, done, selector);
};

exports.focus = function (selector, done) {
    focusSelector.bind(this)(done, selector);
};

exports.userAgent = function (ua, done) {
    this.webview.getWebContents().setUserAgent(ua)
    done()
}

exports.mousedown = function (selector, done) {
    debug(`.mousedown() ${selector}`);
    this.evaluateNow(function (selector) {
        var element = document.querySelector(selector);
        if (!element) {
            throw new Error('Unable to find element by selector: ' + selector);
        }
        var event = document.createEvent('MouseEvent');
        event.initEvent('mousedown', true, true);
        element.dispatchEvent(event);
    }, done, selector);
};

exports.mouseup = function (selector, done) {
    debug(`.mouseup() ${selector}`);
    this.evaluateNow(function (selector) {
        var element = document.querySelector(selector);
        if (!element) {
            throw new Error('Unable to find element by selector: ' + selector);
        }
        var event = document.createEvent('MouseEvent');
        event.initEvent('mouseup', true, true);
        element.dispatchEvent(event);
    }, done, selector);
};

exports.mouseover = function (selector, done) {
    debug(`.mouseover() ${selector}`);
    this.evaluateNow(function (selector) {
        var element = document.querySelector(selector);
        if (!element) {
            throw new Error('Unable to find element by selector: ' + selector);
        }
        var event = document.createEvent('MouseEvent');
        event.initMouseEvent('mouseover', true, true);
        element.dispatchEvent(event);
    }, done, selector);
};

exports.type = function (selector) {
    let text;
    let done;
    if (arguments.length === 2) {
        done = arguments[1];
    } else {
        text = arguments[1];
        done = arguments[2];
    }

    debug(`.type() ${selector} ${text}`);

    var self = this;
    const {webview} = this;

    var chars = String(text).split('');

    function type () {
        var ch = chars.shift();
        if (ch === undefined) {
            return done();
        }

        webview.sendInputEvent({
            type: 'keyDown',
            keyCode: ch
        });

        webview.sendInputEvent({
            type: 'char',
            keyCode: ch
        });

        webview.sendInputEvent({
            type: 'keyUp',
            keyCode: ch
        });

        setTimeout(type, self.options.typeInterval);
    }

    focusSelector.bind(this)(function (err) {
        if (err) {
            return done(err);
        }

        var blurDone = blurSelector.bind(this, done, selector);
        if ((text || '') === '') {
            this.evaluateNow(function (selector) {
                document.querySelector(selector).value = '';
            }, blurDone, selector);
        } else {
            type();
        }
    }, selector);
};

exports.insert = function (selector, text, done) {
    if (arguments.length === 2) {
        done = text;
        text = null;
    }

    debug(`.insert() ${selector} ${text}`);

    const {webview} = this;

    focusSelector.bind(this)(function (err) {
        if (err) {
            return done(err);
        }

        var blurDone = blurSelector.bind(this, done, selector);
        if ((text || '') === '') {
            this.evaluateNow(function (selector) {
                document.querySelector(selector).value = '';
            }, blurDone, selector);
        } else {
            webview.insertText(String(text));
            done();
        }
    }, selector);
};

exports.check = function (selector, done) {
    debug(`.check() ${selector}`);
    this.evaluateNow(function (selector) {
        var element = document.querySelector(selector);
        var event = document.createEvent('HTMLEvents');
        element.checked = true;
        event.initEvent('change', true, true);
        element.dispatchEvent(event);
    }, done, selector);
};

exports.uncheck = function (selector, done) {
    debug(`.uncheck() ${selector}`);
    this.evaluateNow(function (selector) {
        var element = document.querySelector(selector);
        var event = document.createEvent('HTMLEvents');
        element.checked = null;
        event.initEvent('change', true, true);
        element.dispatchEvent(event);
    }, done, selector);
};

exports.select = function (selector, option, done) {
    debug(`.select() ${selector}`);
    this.evaluateNow(function (selector, option) {
        var element = document.querySelector(selector);
        var event = document.createEvent('HTMLEvents');
        element.value = option;
        event.initEvent('change', true, true);
        element.dispatchEvent(event);
    }, done, selector, option);
};

exports.back = function (done) {
    debug('.back()');
    this.evaluateNow(function () {
        window.history.back();
    }, done);
};

exports.forward = function (done) {
    debug('.forward()');
    this.evaluateNow(function () {
        window.history.forward();
    }, done);
};

exports.refresh = function (done) {
    debug('.refresh()');
    this.evaluateNow(function () {
        window.location.reload();
    }, done);
};

exports.wait = function () {
    debug('.wait()');
    var args = sliced(arguments);
    var done = args[args.length - 1];
    if (args.length < 2) {
        return done();
    }

    var arg = args[0];
    if (typeof arg === 'number') {
        if (arg < this.options.waitTimeout) {
            waitms(arg, done);
        } else {
            waitms(this.options.waitTimeout, function () {
                done(new Error('.wait() timed out after ' + this.options.waitTimeout + 'msec'));
            }.bind(this));
        }
    } else if (typeof arg === 'string') {
        var timeout = null;
        if (typeof args[1] === 'number') {
            timeout = args[1];
        }
        waitelem.apply({timeout: timeout}, [this, arg, done]);
    } else if (typeof arg === 'function') {
        args.unshift(this);
        waitfn.apply(this, args);
    } else {
        done();
    }
};

exports.evaluate = function (fn/** , arg1, arg2... **/) {
    debug('.evaluate()');
    var args = sliced(arguments);
    var done = args[args.length - 1];
    var self = this;
    var newDone = function () {
        clearTimeout(timeoutTimer);
        done.apply(self, arguments);
    };
    var newArgs = [fn, newDone].concat(args.slice(1, -1));
    if (typeof fn !== 'function') {
        return done(new Error('.evaluate() fn should be a function'));
    }
    var timeoutTimer = setTimeout(function () {
        done(new Error(`Evaluation timed out after ${self.options.executionTimeout}msec.  Are you calling done() or resolving your promises?`));
    }, self.options.executionTimeout);
    this.evaluateNow.apply(this, newArgs);
};

exports.inject = function (type, file, done) {
    debug('.inject()');
    if (arguments.length === 2) {
        done = file;
        file = null;
    }
    const {webview} = this;
    if (type === 'js') {
        var js = fs.readFileSync(file, {encoding: 'utf-8'});
        this._inject(js, done);
    } else if (type === 'css') {
        var css = fs.readFileSync(file, {encoding: 'utf-8'});
        webview.insertCSS(css);
        done();
    } else {
        this._inject(type, done);
    }
};

exports.scrollTo = function (y, x, done) {
    debug(`.scrollTo() ${x} ${y}`);
    this.evaluateNow(function (y, x) {
        window.scrollTo(x, y);
    }, done, y, x);
};

exports.cookies = {
    get: function (name, done) {
        debug(`.cookies.get() ${name}`);
        var query = {};

        switch (arguments.length) {
            case 2:
                query = typeof name === 'string'
            ? {name: name}
            : name;
                break;
            case 1:
                done = name;
                break;
        }

        const {webview} = this;

        const details = Object.assign({
            url: webview.getURL()
        }, query);

        webview.getWebContents().session.cookies.get(details, function (error, cookies) {
            if (error) return done(error);
            done(null, details.name ? cookies[0] : cookies);
        });
    },
    set: function (name, value, done) {
        debug(`.cookies.set() ${name} ${value}`);
        var cookies = [];

        switch (arguments.length) {
            case 3:
                cookies.push({
                    name: name,
                    value: value
                });
                break;
            case 2:
                cookies = [].concat(name);
                done = value;
                break;
            case 1:
                done = name;
                break;
        }

        const {webview} = this;
        let pending = cookies.length;
        const errors = [];

        for (var i = 0, cookie; (cookie = cookies[i]); i++) {
            var details = Object.assign({
                url: webview.getURL()
            }, cookie);
            webview.getWebContents().session.cookies.set(details, function (error) {
                if (error) errors.push(error);
                if (!--pending) {
                    if (errors.length) return done(errors);
                    done();
                }
            });
        }
    },
    clear: function (name, done) {
        debug(`.cookies.clear() ${name}`);
        var cookies = [];

        switch (arguments.length) {
            case 2:
                cookies = [].concat(name);
                break;
            case 1:
                done = name;
                break;
        }

        const {webview} = this;
        const webContents = webview.getWebContents();
        var url = webview.getURL();
        var getCookies = (cb) => cb(null, cookies);

        if (cookies.length === 0) {
            getCookies = (cb) => webContents.session.cookies.get({url: url}, (error, cookies) => {
                cb(error, cookies.map((cookie) => cookie.name));
            });
        }

        getCookies((error, cookies) => {
            if (error) return done(error); // ?
            var pending = cookies.length;
            if (pending === 0) {
                return done();
            }

            for (var i = 0, cookie; (cookie = cookies[i]); i++) {
                webContents.session.cookies.remove(url, cookie, function (error) {
                    if (error) done(error);
                    else if (!--pending) done();
                });
            }
        });
    },
    clearAll: function (done) {
        debug('.cookies.clearAll()');
        const {webview} = this;
        const webContents = webview.getWebContents();
        webContents.session.clearStorageData({
            storages: ['cookies']
        }, done);
    }
};
