'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var fs = window.require('fs');
var os = window.require('os');
var path = window.require('path');
var mkdirp = window.require('mkdirp');
var sliced = require('sliced');
var once = window.require('once');
var debug = window.require('debug')('avatar:main');
var debugSource = window.require('debug')('avatar:source');
var Events = window.require('events');

var _require = require('./javascript'),
    execute = _require.execute,
    inject = _require.inject;

var actions = require('./actions');
var preload = require('./preload');

var noop = function noop() {};
var keys = Object.keys;
var DEFAULT_HALT_MESSAGE = 'Avatar Halted';

var datadir = path.join(os.tmpdir(), 'avatar');
var preloadFile = path.join(datadir, 'preload.js');

mkdirp.sync(datadir);
fs.writeFileSync(preloadFile, '(' + preload.toString() + ')()');

var container = document.createElement('div');
container.style.width = container.style.height = 0;
container.style.overflow = 'hidden';
document.body.appendChild(container

// wrap all the functions in the queueing function
);function queued(name, fn) {
    return function action() {
        debug('queueing action "' + name + '"');
        var args = [].slice.call(arguments);
        this._queue.push([fn, args]);
        return this;
    };
}

window.__avatars__ = {};

var n = 0;

var Avatar = function (_Events) {
    _inherits(Avatar, _Events);

    function Avatar() {
        var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

        _classCallCheck(this, Avatar);

        var _this = _possibleConstructorReturn(this, (Avatar.__proto__ || Object.getPrototypeOf(Avatar)).call(this));

        _this.state = 'initial';
        _this.running = false;
        _this.ending = false;
        _this.ended = false;
        _this._queue = [];
        _this._headers = [];

        var defaultOptions = {
            waitTimeout: 5 * 60 * 1000, // wait超时时间
            gotoTimeout: 30 * 1000, // 页面加载超时时间
            pollInterval: 250, // wait检测间隔
            typeInterval: 100, // type间隔
            executionTimeout: 30 * 1000, // 执行超时时间
            Promise: Avatar.Promise || Promise,
            container: container,
            url: 'about:blank'
        };

        window.localStorage.debug = '';
        _this.nid = n++;
        options = _this.options = Object.assign({}, defaultOptions, options);
        _this.id = options.id || _this.nid;
        if (options.debug) {
            window.localStorage.debug = options.debug;
        }
        var webview = _this.options.webview || document.createElement('webview');
        webview.style.height = webview.style.width = '100%';
        _this.webview = webview;

        var self = _this;
        function forward(name) {
            return function (event) {
                if (!self._closed) {
                    self.emit(name, event);
                }
            };
        }

        webview.addEventListener('did-finish-load', forward('did-finish-load'));
        webview.addEventListener('did-fail-load', forward('did-fail-load'));
        webview.addEventListener('did-fail-provisional-load', forward('did-fail-provisional-load'));
        webview.addEventListener('did-frame-finish-load', forward('did-frame-finish-load'));
        webview.addEventListener('did-start-loading', forward('did-start-loading'));
        webview.addEventListener('did-stop-loading', forward('did-stop-loading'));
        webview.addEventListener('did-get-response-details', forward('did-get-response-details'));
        webview.addEventListener('did-get-redirect-request', forward('did-get-redirect-request'));
        webview.addEventListener('dom-ready', forward('dom-ready'));
        webview.addEventListener('page-favicon-updated', forward('page-favicon-updated'));
        webview.addEventListener('new-window', forward('new-window'));
        webview.addEventListener('will-navigate', forward('will-navigate'));
        webview.addEventListener('crashed', forward('crashed'));
        webview.addEventListener('plugin-crashed', forward('plugin-crashed'));
        webview.addEventListener('destroyed', forward('destroyed'));
        webview.addEventListener('media-started-playing', forward('media-started-playing'));
        webview.addEventListener('media-paused', forward('media-paused'));
        webview.addEventListener('close', function () {
            _this._closed = true;
            forward('close');
        });

        debug('queuing process start');
        _this._ready = new options.Promise(function (resolve) {
            function didDomReady() {
                webview.removeEventListener('dom-ready', didDomReady);
                resolve();
            }
            webview.addEventListener('dom-ready', didDomReady);
            webview.setAttribute('partition', 'persist:' + _this.id);
            webview.setAttribute('src', options.url);
            webview.setAttribute('disablewebsecurity', true);
            webview.setAttribute('preload', 'file://' + preloadFile);
            options.container.appendChild(webview);
        });
        _this.queue(function (done) {
            debug(_this.id + ' start');
            _this._ready.then(function () {
                debug(_this.id + ' ready');
                done();
            });
        });
        Avatar.namespaces.forEach(function (name) {
            if (typeof this[name] === 'function') {
                this[name] = this[name]();
            }
        }, _this);
        // TODO:
        window.__avatars__[_this.id + '_' + _this.nid] = _this;
        return _this;
    }

    _createClass(Avatar, [{
        key: '_end',
        value: function _end(fn) {
            delete window.__avatars__[this.id + '_' + this.nid];
            if (this.webview) {
                this.webview.stop();
                this.webview.remove();
                this.webview = null;
            }
            this.ended = true;
            fn();
        }
    }, {
        key: 'destroy',
        value: function destroy() {
            this.halt();
        }
    }, {
        key: 'run',
        value: function run(fn) {
            var _this2 = this;

            debug('running');
            var steps = this.queue();
            this.running = true;
            this._queue = [];
            this.queue(function (done) {
                _this2._ready.then(function () {
                    done();
                });
            });
            var self = this;

            // kick us off
            next();

            // next function
            function next(err, res) {
                var item = steps.shift();
                // Immediately halt execution if an error has been thrown, or we have no more queued up steps.
                if (err || !item) return done.apply(self, arguments);
                var args = item[1] || [];
                var method = item[0];
                args.push(once(after));
                method.apply(self, args);
            }

            function after(err, res) {
                err = err || self.die;
                var args = sliced(arguments);
                next.apply(self, args);
            }

            function done() {
                debug('run success');
                var doneargs = arguments;
                self.running = false;
                if (self.ending) {
                    self._end(function () {
                        return fn.apply(self, doneargs);
                    });
                }
                return fn.apply(self, doneargs);
            }

            return this;
        }
    }, {
        key: 'queue',
        value: function queue(done) {
            if (!arguments.length) return this._queue;
            var args = sliced(arguments);
            var fn = args.pop();
            this._queue.push([fn, args]);
        }
    }, {
        key: 'end',
        value: function end(done) {
            this.ending = true;

            if (done && !this.running && !this.ended) {
                return this.then(done);
            }

            return this;
        }
    }, {
        key: 'halt',
        value: function halt(error, done) {
            this.ending = true;
            var queue = this.queue(); // empty the queue
            queue.splice(0);
            if (!this.ended) {
                var message = error;
                if (error instanceof Error) {
                    message = error.message;
                }
                this.die = message || DEFAULT_HALT_MESSAGE;
                if (typeof this._rejectActivePromise === 'function') {
                    this._rejectActivePromise(error || DEFAULT_HALT_MESSAGE);
                }
                var callback = done;
                if (!callback || typeof callback !== 'function') {
                    callback = noop;
                }
                this._end(callback);
            }
            return this;
        }
    }, {
        key: 'then',
        value: function then(fulfill, reject) {
            var _this3 = this;

            return new this.options.Promise(function (success, failure) {
                _this3._rejectActivePromise = failure;
                _this3.run(function (err, result) {
                    if (err) failure(err);else success(result);
                });
            }).then(fulfill, reject);
        }
    }, {
        key: 'catch',
        value: function _catch(reject) {
            this._rejectActivePromise = reject;
            return this.then(undefined, reject);
        }
    }, {
        key: 'header',
        value: function header(_header, value) {
            if (_header && typeof value !== 'undefined') {
                this._headers[_header] = value;
            } else {
                this._headers = _header || {};
            }
            return this;
        }
    }, {
        key: '_inject',
        value: function _inject(js, done) {
            var webview = this.webview;

            var source = inject({ src: js });
            debugSource('inject source: ' + source);
            webview.executeJavaScript(source, function (response) {
                if (response.err) {
                    return done(response.err);
                }
                done(null, response.result);
            });
            return this;
        }
    }, {
        key: 'evaluateNow',
        value: function evaluateNow(fn, done) {
            var webview = this.webview;

            if (!webview.executeJavaScript) throw new Error('webview do not ready, can not call executeJavaScript.');
            var args = Array.prototype.slice.call(arguments).slice(2).map(function (a) {
                return { argument: JSON.stringify(a) };
            });
            var source = execute({ src: String(fn), args: args });
            debugSource('evaluate source: ' + source);
            webview.executeJavaScript(source, function (response) {
                if (response.err) {
                    return done(response.err);
                }
                done(null, response.result);
            });
            return this;
        }
    }, {
        key: 'use',
        value: function use(fn) {
            fn(this);
            return this;
        }
    }]);

    return Avatar;
}(Events);

Avatar.namespaces = [];
Avatar.Promise = Promise;
Avatar.action = function (name, fn) {
    if (typeof fn === 'function') {
        Avatar.prototype[name] = queued(name, fn);
    } else {
        if (!~Avatar.namespaces.indexOf(name)) {
            Avatar.namespaces.push(name);
        }
        Avatar.prototype[name] = function () {
            var self = this;
            return keys(fn).reduce(function (obj, key) {
                obj[key] = queued(name, fn[key]).bind(self);
                return obj;
            }, {});
        };
    }
};

Object.keys(actions).forEach(function (name) {
    var fn = actions[name];
    Avatar.action(name, fn);
});

module.exports = Avatar;