import React, { useState, useEffect, useRef } from 'react';
import styles from './index.less';
import { Button, Form, Card, Input } from 'antd';
import {  setToken, delToken, setUserName, delUserName, getUserName } from '../local';
import * as fn from '../api';
const { sign } = fn.default;

const tailLayout = {
  wrapperCol: { offset: 5, span: 19 },
};

const layout = {
  labelCol: { span: 5 },
  wrapperCol: { span: 19 },
};

export default function LoginPage() {
 

  const onFinish = async (values: any) => {
    console.log('Success:', values);
    let a = await sign(values);
    console.dir(a);
    setUserName(a.username);
    setToken('Bearer ' + a.token);
    return window.location.href = '/';
  };

  const onFinishFailed = (errorInfo: any) => {
    console.log('Failed:', errorInfo);
  };


  return (
    <div className="box">
      <div className = 'flex c' style={{ height: '100%', background: '#001529' }} >
        <Card
          className = { 'm' }
          title = { '运营管理系统' } 
          extra = { <span>登录</span> }
          style = {{ width:400,margin:'auto' }}
        >   
          <Form
                {...layout}
                name="basic"
                onFinish={onFinish}
                onFinishFailed={onFinishFailed}
              >
                <Form.Item
                  label="用户名"
                  name="username"
                  rules={[{ required: true, message: '请输入账号' }]}
                >
                  <Input />
                </Form.Item>

                <Form.Item
                  label="密码"
                  name="password"
                  rules={[{ required: true, message: '请输入密码!' }]}
                >
                  <Input.Password />
                </Form.Item>

                <Form.Item {...tailLayout}>
                  <Button type="primary" htmlType="submit">
                    提交
                  </Button>
                </Form.Item>
            </Form>
        </Card>
      </div>
    </div>
  );
}
